import http from '@/config/request';
import {router} from '@/config/router';
import Store from '@/config/store/index';
const state = {
	token: uni.getStorageSync("token") || "",
	isLogin: uni.getStorageSync("isLogin") || false, // 是否登陆
	userInfo: uni.getStorageSync("userInfo") || {}, // 用户信息
	Tabs: [
		{
			activeImage: '',
			image: '',
		}
	]
}

const getters = {
	token: state => state.token,
	isLogin: state => state.isLogin,
	userInfo: state => state.userInfo,
	Tabs: state => state.Tabs
}

const actions = {
	async login({
		commit
	},data){
		return new Promise((resolve, reject) => {
			http('user.login',data,'加载中...').then(res => {
				if(res){
					commit("token", res.data.accessToken);
					commit("isLogin", true);
					commit("userInfo", res.data);
					resolve(res);
				}
			}).catch(e => {
				reject(e)
			})
		})
	},
	logout({commit}){
		commit("token", "");
		commit("isLogin", false);
		commit("userInfo", {});
	}
}

const mutations = {
	token(state, payload) {
		state.token = payload;
		uni.setStorageSync("token", payload);
	},
	// 登录态
	isLogin(state, data) {
		state.isLogin = data;
		uni.setStorageSync('isLogin', data);
	},
	// 用户信息
	userInfo(state, data) {
		state.userInfo = data;
		uni.setStorageSync("userInfo", data);
	}
}
export default {
	state,
	mutations,
	actions,
	getters
}
