import Vue from 'vue'
import App from './App'

Vue.config.productionTip = false

import {
  router,
  RouterMount
} from "@/config/router";
import store from "@/config/store";
import uView from "uview-ui";
import appConfig from "@/config/index";


async function bootstrap() {
  App.mpType = "app";
  //引入路由
  Vue.use(router);
  // 引入全局uView
  Vue.use(uView);
  // 加载app
  Vue.use(appConfig);

  const app = new Vue({
    store,
    ...App
  });
  // #ifdef H5
  RouterMount(app, router, "#app");
  // #endif
  // #ifndef H5
  app.$mount();
  // #endif
}

bootstrap();

