export default {
    data(){
        return{
            headerHeight: 0,
            footerHeight: 0
        }
    },
    methods:{
        getHeaderHeight(){
            this.$nextTick(() =>{
                this.uGetRect("#header").then(res =>{
                    this.headerHeight = res.height;
                })
            })
        },
        getFooterHeight(){
            this.$nextTick(() =>{
                this.uGetRect("#footer").then(res =>{
                    this.footerHeight = res.height;
                })
            })
        },
        uGetRect(selector, all) {
            return new Promise((resolve) => {
                uni.createSelectorQuery()
                    .in(this)[all ? 'selectAll' : 'select'](selector)
                    .boundingClientRect((rect) => {
                        if (all && Array.isArray(rect) && rect.length) {
                            resolve(rect)
                        }
                        if (!all && rect) {
                            resolve(rect)
                        }
                        if(rect === null){
                            resolve({})
                        }
                    })
                    .exec()
            })
        },
    },
    mounted() {
        this.getHeaderHeight();
        this.getFooterHeight();
    },
}
