export default {
    data(){
        return {
            system_info:{}, //system info
            canvas_width:0, //canvas width px
            canvas_height:0, //canvas height px
            ctx:null, //canvas object
            canvas_id:null, //canvas id
            hidden:false, //Whether to hide canvas
            scale:1, //canvas scale
            r_canvas_scale:1,
            if_ctx:true
        }
    },
    methods:{
        /**
         * Compatibility px
         * @param {Object} size
         */
        compatibilitySize(size) {
            let canvasSize = (parseFloat(size) / 750) * this.system_info.windowWidth
            canvasSize = parseFloat(canvasSize * 2)
            return canvasSize
        },
        /**
         * Restore compatibility px
         * @param {Object} size
         */
        resetCompatibilitySize(size) {
            return (parseFloat(size / 2) / this.system_info.windowWidth) * 750
        },
        init(config){
            return new Promise(async (resolve,reject)=>{
                if(!config.canvas_id){
                    reject("Canvas ID cannot be empty, please refer to the usage example")
                    return;
                }
                this.hidden = config.hidden
                this.canvas_id = config.canvas_id
                let system_info = await uni.getSystemInfoSync()
                this.system_info = system_info
                this.scale = config.scale && parseFloat(config.scale)>0?parseInt(config.scale):1
                this.canvas_width = (config.canvas_width ? this.compatibilitySize(config.canvas_width) : system_info.windowWidth) * this.scale
                this.canvas_height = (config.canvas_height ? this.compatibilitySize(config.canvas_height) : system_info.windowHeight) * this.scale,
                    this.r_canvas_scale = 1/this.scale
                this.ctx = uni.createCanvasContext(this.canvas_id,this)
                // this.setCanvasConfig({
                //     global_alpha:config.global_alpha?parseFloat(config.global_alpha):1,
                //     backgroundColor:config.background_color?config.background_color:"#fff"
                // })
                resolve()
            })
        },
        clearCanvas(){
            return new Promise(async (resolve,reject)=>{
                if(!this.ctx){
                    reject("canvas is not initialized:101")
                    return
                }else{
                    this.ctx.clearRect(0,0,parseFloat(this.canvas_width)*this.scale,parseFloat(this.canvas_height)*this.scale)
                    await this.draw()
                    resolve()
                }
            })
        },

        draw(){

        }
    }
}
