export default {
    data(){
        return {
            MaterialList: [],
            materialDetail: {}
        }
    },
    computed:{
        title(){
            return this.materialDetail.materialName;
        },
    },
    methods:{
        getMaterialList(){
            this.$http("materialinfo.getMaterialList",{
                isDisabled: false,
                isFilter: true,
                materialType: "面料",
                current: 1,
                size: 10,
            }).then(res =>{
                let {
                    code, data
                } = res;
                if(code === 200){
                    this.MaterialList = data.page.records;
                }
            })
        },
        // 获取面料详情
        getMaterialItem(id,callback){
            this.$http("materialinfo.getMaterialById", id)
                .then(res =>{
                    let {
                        code, data
                    } = res;
                    if(code === 200){
                        if(callback){
                            callback(data)
                        }else{
                            this.materialDetail = data;
                        }
                    }
                })
        },
    }
}
