export default {
    data(){
        return{
            offset :{
                x: 0
            },
            startTime: 0,
            lineStepWidth: 0,
            lineWidth: 0,
            lineOffset: 0,
        }
    },
    computed:{
        // 角度
        angle(){
            let { lineOffset,offset,lineWidth} = this;
            let left = (offset.x - lineOffset.left) / lineWidth * 100;
            return Math.ceil((left-50) / 50 * 180);
        },
    },
    methods:{
        // 重置调整的进度条
        initStep(){
            this.uGetRect("#line").then(res => {
                this.lineWidth = res.width;
                this.lineOffset = {
                    left: res.left,
                    right: res.right,
                };
                this.offset.x = res.width / 2  + res.left;
            })
            this.uGetRect("#line-step").then(res => {
                this.lineStepWidth = res.width;
            })
        },
        resetStep(){
            this.offset.x = this.lineWidth  / 2  + this.lineOffset.left;
        },
        touchMove(e){
            let left =  e.changedTouches[0].pageX;
            this.offset.x = this.filterStartEnd(left)
        },
        touchEnd(e){
            let left =  e.changedTouches[0].pageX;
            this.offset.x = this.filterStartEnd(left)
        },
        touchStart(e){
            this.offset.x = e.changedTouches[0].pageX;
        },
        filterStartEnd(num){
            let { left,right } = this.lineOffset;
            if(num < left){
                return left
            }else if(num > right){
                return right
            }else{
                return num
            }
        }
    },
    mounted() {
        this.initStep()
    },
}
