# -*- coding:utf-8 -*-

# import paramiko
import logging
import os
from logging import handlers


class Logger(object):
    def __init__(self, filename, level='info', when='D', backCount=3, fmt='[%(asctime)s] - %(levelname)s: %(message)s'):
        self.logger = logging.getLogger(filename)
        format_str = logging.Formatter(fmt)  # 设置日志格式
        self.logger.setLevel(level)  # 设置日志级别
        sh = logging.StreamHandler()  # 往屏幕上输出
        sh.setFormatter(format_str)  # 设置屏幕上显示的格式
        th = handlers.TimedRotatingFileHandler(filename=filename, when=when, backupCount=backCount,
                                               encoding='utf-8')  # 往文件里写入#指定间隔时间自动生成文件的处理器
        # 实例化TimedRotatingFileHandler
        # interval是时间间隔，backupCount是备份文件的个数，如果超过这个个数，就会自动删除，when是间隔的时间单位，单位有以下几种：
        # S 秒
        # M 分
        # H 小时、
        # D 天、
        # W 每星期（interval==0时代表星期一）
        # midnight 每天凌晨
        th.setFormatter(format_str)  # 设置文件里写入的格式
        # self.logger.addHandler(sh)  # 把对象加到logger里
        self.logger.addHandler(th)

    def error(self, msg, *args, **kwargs):
        return self.logger.error(msg, *args, **kwargs)

    def info(self, msg, *args, **kwargs):
        return self.logger.info(msg, *args, **kwargs)

    def debug(self, msg, *args, **kwargs):
        return self.logger.debug(msg, *args, **kwargs)

    def warning(self, msg, *args, **kwargs):
        return self.logger.warning(msg, *args, **kwargs)

    def critical(self, msg, *args, **kwargs):
        return self.logger.critical(msg, *args, **kwargs)


log = Logger(os.path.join(os.getcwd(), 'upgrade_log.log'), level=logging.DEBUG)


class FileHelper():
    @staticmethod
    def get_file_content(file_name):
        '''
        获取文件内容
        :param file_name:
        :return:
        '''
        with open(file_name, 'r', encoding='utf-8') as f:
            content = f.read()

        return content

    @staticmethod
    def set_file_content(file_name, file_content):
        '''
        设置文件内容
        :param file_name:
        :param file_content:
        :return:
        '''
        with open(file_name, 'w', encoding='utf-8') as f:
            f.write(file_content)


class ShellManage():
    def exec_shell(self, shell_message):
        '''
        执行shell命令
        :param sehll_message:
        :return:
        '''
        result = os.system(shell_message)
        log.info('执行命令:\n{}'.format(shell_message))

        if result == 1:
            raise RuntimeError('执行【{}】出错'.format(shell_message))

    def get_shell_message(self, shell_message):
        '''
        获取shell命令的返回信息
        :param shell_message:
        :return:
        '''
        with os.popen(shell_message) as f:
            txt = f.read()

        log.info('执行了命令:\n{}，返回结果为:\n{}'.format(shell_message, txt))
        return txt

    def get_txt(self):
        '''
        测试
        :param file_path:
        :return:
        '''
        with open('docker images.txt', 'r') as f:
            txt = f.read()

        return txt


# class SSHConnection(object):
#
#     def __init__(self, host=None, port=None, username=None, pwd=None):
#         self.__host = host
#         self.__port = port
#         self.__username = username
#         self.__pwd = pwd
#         self.__transport = None
#         self.__k = None
#
#     def connect(self):
#         # 创建连接对象
#         transport = paramiko.Transport((self.__host, self.__port))
#         transport.connect(username=self.__username, password=self.__pwd)
#         self.__transport = transport
#
#     def close(self):
#         # 关闭连接
#         self.__transport.close()
#
#     def upload(self, local_path, target_path):
#         """
#         本地上传文件到服务器
#         :param local_path: 本地文件地址
#         :param target_path: 目标文件路径
#         """
#         sftp = paramiko.SFTPClient.from_transport(self.__transport)
#         sftp.put(local_path, target_path)
#
#     def download(self, remote_path, local_path):
#         """
#         服务器下载文件到本地
#         :param remote_path: 服务器文件路径
#         :param local_path: 本地目标路径
#         """
#         sftp = paramiko.SFTPClient.from_transport(self.__transport)
#         sftp.get(remote_path, local_path)
#
#     def cmd(self, command):
#         """
#         执行指定命令
#         :param command: 命令
#         :return:输入，输出，错误
#         """
#         ssh = paramiko.SSHClient()
#         ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
#         ssh._transport = self.__transport
#         # 执行命令，标准输入，输出，错误
#         stdin, stdout, stderr = ssh.exec_command(command)
#         # 获取命令结果
#         outputs = stdout.read()
#         return outputs
