# -*- coding:utf-8 -*-
import os

docker_service = '''[Unit]
Description=Docker Application Container Engine
Documentation=https://docs.docker.com
After=network-online.target firewalld.service
Wants=network-online.target

[Service]
Type=notify
# the default is not to use systemd for cgroups because the delegate issues still
# exists and systemd currently does not support the cgroup feature set required
# for containers run by docker
ExecStart=/usr/bin/dockerd
ExecReload=/bin/kill -s HUP $MAINPID
# Having non-zero Limit*s causes performance problems due to accounting overhead
# in the kernel. We recommend using cgroups to do container-local accounting.
LimitNOFILE=infinity
LimitNPROC=infinity
LimitCORE=infinity
# Uncomment TasksMax if your systemd version supports it.
# Only systemd 226 and above support this version.
#TasksMax=infinity
TimeoutStartSec=0
# set delegate yes so that systemd does not reset the cgroups of docker containers
Delegate=yes
# kill only the docker process, not all processes in the cgroup
KillMode=process
# restart the docker process if it exits prematurely
Restart=on-failure
StartLimitBurst=3
StartLimitInterval=60s

[Install]
WantedBy=multi-user.target'''


def install_docker():
    '''
    安装docker
    :return:
    '''
    print('解压tar包...')
    res = os.system('sudo tar -xvf docker-19.03.4.tgz')
    if res == 1: raise RuntimeError('解压tar包失败')

    print('将docker目录移到/usr/bin目录下...')
    res = os.system('sudo cp docker/* /usr/bin/')
    if res == 1: raise RuntimeError('将docker目录移到/usr/bin目录下失败')

    print('在/etc/systemd/system/目录下创建docekr.service...')
    with open('/etc/systemd/system/docker.service', 'w') as f:
        f.write(docker_service)

    print('添加文件权限...')
    res = os.system('sudo chmod +x /etc/systemd/system/docker.service')
    if res == 1: raise RuntimeError('添加文件权限失败')

    print('新增配置文件/etc/docker/daemon.json...')
    if not os.path.exists('/etc/docker'):
        os.mkdir('/etc/docker')
    with open('/etc/docker/daemon.json', 'w') as f:
        f.write('''{
    "registry-mirrors":["https://m6wlkecl.mirror.aliyuncs.com"],
    "insecure-registries": ["http://47.110.145.204:8084","http://183.134.73.2:8084"],
    "log-driver": "json-file",
    "log-opts": {
        "max-size": "50m",
        "max-file": "3"
    }
}''')

    print('重新加载配置文件...')
    res = os.system('sudo systemctl daemon-reload')
    if res == 1: raise RuntimeError('重新加载配置文件失败')

    print('启动docker...')
    res = os.system('sudo systemctl start docker')
    if res == 1: raise RuntimeError('启动docker失败')

    print('设置开机自启...')
    res = os.system('sudo systemctl enable docker.service')
    if res == 1: raise RuntimeError('设置开机自启失败')

    print('查看docker版本...')
    res = os.system('docker -v')
    if res == 1: raise RuntimeError('查看docker版本失败')


def install_docker_compose():
    '''
    安装docker_compose
    :return:
    '''
    print('修改/etc/selinux/config下的SELINUX属性')
    with open('/etc/selinux/config', 'r') as f:
        config = f.read()
    config = config.replace('SELINUX=enforcing', 'SELINUX=disabled')
    with open('/etc/selinux/config', 'w') as f:
        f.write(config)

    print('移动文件至/usr/local/bin/docker-compose...')
    res = os.system('sudo mv docker-compose-Linux-x86_64 /usr/local/bin/docker-compose')
    if res == 1: raise RuntimeError('移动文件至/usr/local/bin/docker-compose失败')

    print('添加可执行权限...')
    res = os.system('sudo chmod +x /usr/local/bin/docker-compose')
    if res == 1: raise RuntimeError('添加可执行权限失败')

    print('查看docker-compose版本...')
    res = os.system('docker-compose -v')
    if res == 1: raise RuntimeError('查看docker-compose版本失败')


def close_firewalld():
    '''
    关闭防火墙
    :return:syste
    '''
    print('关闭防火墙...')
    res = os.system('''systemctl stop firewalld && systemctl disable firewalld''')
    if res == 1: raise RuntimeError('关闭防火墙失败')


if __name__ == "__main__":
    from set_env import init_env

    init_env()
    close_firewalld()
    install_docker()
    install_docker_compose()
    os.system('mkdir /huansi')
    os.system('mkdir /huansi/upgrade')
    print('*****************************************************')
    print('********服务器需要重启,请输入reboot重启服务器*************')
    print('*****************************************************')
