# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.conncetion.conncetion_service import ConnectionService


@api('connection')
class ConnectionAPI(ApiController):
    @api()
    def get_project_info(self):
        '''
        获取项目信息
        :return:
        '''
        return ConnectionService().get_project_info()

    @api()
    def post_set_project_info(self):
        '''
        设置项目信息
        :return:
        '''
        return ConnectionService().set_project_info(request.json)

    @api('<string:project_no>/<string:db_name>')
    def get_test_conncetion(self, project_no, db_name):
        '''
        测试项目数据库连接
        :param project_no:
        :param db_name:
        :return:
        '''
        return ConnectionService().test_connection(project_no, db_name)

    @api('remote_server')
    def get_remote_server(self):
        '''
        获取远程服务器连接
        :return:
        '''
        return ConnectionService().get_remote_server_info()

    @api('remote_server')
    def post_set_remote_server_info(self):
        '''
        设置远程服务器连接
        :return:
        '''
        return ConnectionService().set_remote_server_info(request.json)

    @api('test_port/<int:port>')
    def get_test_port(self, port):
        '''
        测试端口是否开放
        :param port:
        :return:
        '''
        return ConnectionService().test_port(port)
