# -*- coding:utf-8 -*-
import os

from huansi_utils.exception.exception import HSException
from huansi_utils.server.service_uc import HSBaseUCService

from app.conncetion.conncetion_service import ConnectionService
from app.utils.ssh_tools import SSHConnect


class InstallService(HSBaseUCService):

    def install_runner(self):
        '''
        安装runner
        :return:
        '''
        conncetion_service = ConnectionService()
        project_info = conncetion_service.get_project_info()
        if not project_info:
            raise HSException('项目信息未查到，请先配置')
        project_code = project_info['project_no']
        self.install_huansi_runner(project_code)

    def install_huansi_runner(self, HSCUSCODE):
        '''
        安装
        :param HSCUSCODE:
        :return:
        '''
        self.delete_setting_file()
        s1 = os.system("docker run --rm -t -i -v /etc/gitlab-runner:/etc/gitlab-runner gitlab/gitlab-runner register \
                           -n -u http://47.110.145.204:8085/ -r WwpzH4qk19KjvAjEwoTz --executor docker --docker-image docker \
                           --description huansi.{hscode} \
                           --tag-list huansi.{hscode}".format(hscode=HSCUSCODE))
        if s1 != 0:
            raise HSException('gitlab-runner安装失败')
        self._edit_runner_setting()
        self._remove_old_runner_container()
        self.start_runner()

    def _edit_runner_setting(self):
        os.system("sudo chmod 777 /etc/gitlab-runner/config.toml")
        with open('/etc/gitlab-runner/config.toml', 'r') as f:
            s = f.read()
            a = s.replace('volumes = ["/cache"]',
                          'volumes = ["/var/run/docker.sock:/var/run/docker.sock","/etc/profile.d/huansi.sh:/etc/profile.d/huansi.sh" ,"/cache","/huansi/gitlab-runner/builds:/builds/hs"]')
        with open('/etc/gitlab-runner/config.toml', 'w') as f:
            f.write(a)

    def _remove_old_runner_container(self):
        '''
        移除旧runner容器，主要作用于第二次第三次的重复安装
        :return:
        '''
        os.system("docker stop gitlab-runner && docker rm gitlab-runner")

    def start_runner(self):
        s = os.system("docker run -d --name gitlab-runner --restart always \
                       -v /etc/gitlab-runner:/etc/gitlab-runner \
                       -v /var/run/docker.sock:/var/run/docker.sock \
                       -v /etc/profile.d/huansi.sh:/etc/profile.d/huansi.sh \
                       gitlab/gitlab-runner:latest")

        if s != 0:
            raise HSException('启动runner失败')

    def delete_setting_file(self):
        os.system('rm -f /etc/gitlab-runner/config.toml')

    def install_remote_service_docker(self):
        '''
        安装远端服务器的docker
        :return:
        '''
        remote_server_info = ConnectionService().get_remote_server_info()
        if not remote_server_info:
            raise HSException('远端服务器信息未查到，请先配置')

        ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                 host_port=remote_server_info['server_ssh_port'],
                                 user_name=remote_server_info['server_user'],
                                 password=remote_server_info['server_password'])

        with ssh_conenct as ssh:
            InstallDocker(ssh).run()


docker_service = '''[Unit]
Description=Docker Application Container Engine
Documentation=https://docs.docker.com
After=network-online.target firewalld.service
Wants=network-online.target

[Service]
Type=notify
# the default is not to use systemd for cgroups because the delegate issues still
# exists and systemd currently does not support the cgroup feature set required
# for containers run by docker
ExecStart=/usr/bin/dockerd
ExecReload=/bin/kill -s HUP $MAINPID
# Having non-zero Limit*s causes performance problems due to accounting overhead
# in the kernel. We recommend using cgroups to do container-local accounting.
LimitNOFILE=infinity
LimitNPROC=infinity
LimitCORE=infinity
# Uncomment TasksMax if your systemd version supports it.
# Only systemd 226 and above support this version.
#TasksMax=infinity
TimeoutStartSec=0
# set delegate yes so that systemd does not reset the cgroups of docker containers
Delegate=yes
# kill only the docker process, not all processes in the cgroup
KillMode=process
# restart the docker process if it exits prematurely
Restart=on-failure
StartLimitBurst=3
StartLimitInterval=60s

[Install]
WantedBy=multi-user.target'''


class InstallDocker(object):
    def __init__(self, ssh: SSHConnect):
        self.ssh = ssh

    def run(self):
        self._close_firewalld()
        self._install_docker()
        self._install_docker_compose()

        self.ssh.exec_command('sudo mkdir -p /huansi && sudo mkdir -p /huansi/upgrade')
        print('*****************************************************')
        print('********服务器需要重启,请输入reboot重启服务器*************')
        print('*****************************************************')

    def _close_firewalld(self):
        print('关闭防火墙...')
        out, err = self.ssh.exec_command('systemctl stop firewalld && systemctl disable firewalld')
        print(out)
        if err: raise RuntimeError('关闭防火墙失败')

    def _install_docker_compose(self):
        print('修改/etc/selinux/config下的SELINUX属性')
        out, err = self.ssh.exec_command("sed -i 's/SELINUX=enforcing/SELINUX=disabled/g' /etc/selinux/config")
        print(out)
        if err: raise RuntimeError('修改/etc/selinux/config下的SELINUX属性失败')

        print('移动文件至/usr/local/bin/docker-compose...')
        out, err = self.ssh.exec_command('sudo mv docker-compose-Linux-x86_64 /usr/local/bin/docker-compose')
        print(out)
        if err: raise RuntimeError('移动文件至/usr/local/bin/docker-compose失败')

        print('添加可执行权限...')
        out, err = self.ssh.exec_command('sudo chmod +x /usr/local/bin/docker-compose')
        print(out)
        if err: raise RuntimeError('添加可执行权限失败')

        print('查看docker-compose版本...')
        out, err = self.ssh.exec_command('docker-compose -v')
        print(out)
        if err: raise RuntimeError('查看docker-compose版本失败')

    def _install_docker(self):
        print('解压tar包...')
        out, err = self.ssh.exec_command('sudo tar -xvf docker-19.03.4.tgz')
        print(out)
        if err: raise RuntimeError('解压tar包失败')

        print('将docker目录移到/usr/bin目录下...')
        out, err = self.ssh.exec_command('sudo cp docker/* /usr/bin/')
        print(out)
        if err: raise RuntimeError('将docker目录移到/usr/bin目录下失败')

        print('在/etc/systemd/system/目录下创建docekr.service...')
        out, err = self.ssh.exec_command(f"""sudo tee /etc/systemd/system/docker.service <<-'EOF'
{docker_service}
EOF""")
        print(out)
        if err: raise RuntimeError('在/etc/systemd/system/目录下创建docekr.service失败')

        print('添加文件权限...')
        out, err = self.ssh.exec_command('sudo chmod +x /etc/systemd/system/docker.service')
        print(out)
        if err: raise RuntimeError('添加文件权限失败')

        print('新增配置文件/etc/docker/daemon.json...')
        out, err = self.ssh.exec_command("""sudo mkdir -p /etc/docker && sudo tee /etc/docker/daemon.json <<-'EOF'
{
    "registry-mirrors":["https://m6wlkecl.mirror.aliyuncs.com"],
    "insecure-registries": ["http://47.110.145.204:8084","http://183.134.73.2:8084"],
    "log-driver": "json-file",
    "log-opts": {
        "max-size": "50m",
        "max-file": "3"
    }
}
EOF""")
        print(out)
        if err: raise RuntimeError('新增配置文件/etc/docker/daemon.json失败')

        print('重新加载配置文件...')
        out, err = self.ssh.exec_command('sudo systemctl daemon-reload')
        print(out)
        if err: raise RuntimeError('重新加载配置文件失败')

        print('启动docker...')
        out, err = self.ssh.exec_command('sudo systemctl start docker')
        print(out)
        if err: raise RuntimeError('启动docker失败')

        print('设置开机自启...')
        out, err = self.ssh.exec_command('sudo systemctl enable docker.service')
        print(out)
        if err: raise RuntimeError('设置开机自启失败')

        print('查看docker版本...')
        out, err = self.ssh.exec_command('docker -v')
        print(out)
        if err: raise RuntimeError('查看docker版本失败')
