# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.upgrade.upgrade_service import UpgradeService


@api('upgrade')
class UpgradeAPI(ApiController):
    '''
    1、回滚升级
    2、远程升级
    3、导出安装包
    4、导入安装包升级(不紧急)
    '''

    @api('rollback/<int:log_id>')
    def get_rollback_upgrade(self, log_id):
        '''
        回滚升级
        :return:
        '''
        return UpgradeService().rollback_upgrade(log_id)

    @api('remote')
    def get_remote_upgrade(self):
        '''
        远程升级
        :return:
        '''
        log_id = request.args.get('log_id')
        return UpgradeService().remote_upgrade(log_id)

    @api('package_images/<int:log_id>')
    def get_package_images(self, log_id):
        '''
        导出镜像
        :param log_id:
        :return:
        '''
        return UpgradeService().package_images(log_id)
