# -*- coding:utf-8 -*-
import os
import re

from huansi_utils.app.apploader import logger
from huansi_utils.exception.exception import HSException

from app.conncetion.conncetion_service import ConnectionService
from app.info.info_service import docker_client
from app.utils.db_tools import db_driver
from app.utils.ssh_tools import SSHConnect
from static_file import back_up_dir, builds_dir, temp_file_dir, system_file_dir


class UpgradeService():
    def rollback_upgrade(self, log_id):
        '''
        回滚升级
        :param log_id:
        :return:
        '''
        logger.info(f'开始回滚{log_id}......')
        # 找到对应版本
        with db_driver as session:
            # 当前版本不让回滚
            query_sql = f'''select * from app_upgrade_log where id={log_id}'''
            data = session.retrive_sql(query_sql)

            if data['default_version'] == 1:
                raise HSException('该版本已经是最新版本，不能进行回滚操作')

            # 找到记录的镜像信息
            sql = f'''select * from app_upgrade_log_dtl where log_id={log_id}'''
            image_info_list = session.query_sql(sql)

        # 找出升级版本号
        upgrade_no = data.get('upgrade_no')
        # 找到这个版本备份的compose文件
        docker_compose_file_dir = self.find_compose_by_upgrade_no(upgrade_no)

        # 挨个去找对应版本中的镜像然后逐一tag
        for image_info in image_info_list:
            app_image_id = image_info['app_image_id']
            app_image_name = image_info['app_image_name']

            # 系统中找镜像，如果镜像是None，重新tag，如果不是None，就不用处理了
            find_image_command = "docker images |grep " + app_image_id[:12] + " | awk '{print $2}'"
            with os.popen(find_image_command) as command:
                actual_image_verison = command.read()

            if not actual_image_verison:
                raise HSException(f'找不到对应的{app_image_id}的镜像')

            logger.info(f'镜像{app_image_id}的镜像版本号为{actual_image_verison}')

            # tag它
            if actual_image_verison == '<none>':
                logger.info(f'tag镜像{app_image_id}为{app_image_name}')
                res = os.system(f'docker tag {app_image_id[:12]} {app_image_name}')
                if res == 1: raise HSException(f'Tag{app_image_name}镜像失败')
            else:
                # 有版本就不管
                pass
        # 找到app_list
        app_list = self.get_app_list_from_compose_file(docker_compose_file_dir)
        # docker-compose
        project_info = ConnectionService().get_project_info()
        host_ip = project_info['host_ip']
        ssh_conenct = SSHConnect(user_name='root', password='huansi.net', host_port='1111', host_ip=host_ip)
        with ssh_conenct as ssh:
            out, err = ssh.exec_command(
                f'''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose -f /data/upgrade_tools_data/backup/{upgrade_no}/docker-compose.yml -p deploy up -d --force-recreate --no-deps {app_list}''')
            # 会有问题，docker-compose编译的时候，会把过程放到err上，所以注释这段
            # if err:
            #     raise HSException(f'回滚失败:{err}')
            if err:
                logger.info(f"有报错信息：{err}")
            logger.info(f'回滚{app_list}成功：{out}')

        with db_driver as session:
            # 对应的版本信息修改为当前版本
            session.exec_sql(f'update app_upgrade_log set default_version=1 where id={log_id}')
            session.exec_sql(f'update app_upgrade_log set default_version=0 where id<>{log_id}')

        return {'message': err, "out": out}
        # 注意异常情况下的处理

    def find_compose_by_upgrade_no(self, upgrade_no):
        '''
        找到这个版本备份的compose文件
        :param upgrade_no:
        :return:
        '''
        docker_compose_file_dir = os.path.join(back_up_dir, upgrade_no, 'docker-compose.yml')
        logger.info(f'备份的compose文件地址:{docker_compose_file_dir}')
        if not os.path.exists(docker_compose_file_dir):
            raise HSException(f'未找到{docker_compose_file_dir}')
        return docker_compose_file_dir

    def remote_upgrade(self, log_id=None):
        '''
        远程升级
        :return:
        '''

        upgrade_no = self.get_upgrade_no_by_log_id(log_id)

        self._package_images(upgrade_no)

        # 找到服务器ip
        # 上传app包到服务器
        remote_server_info = ConnectionService().get_remote_server_info()
        if not remote_server_info:
            raise HSException('远端服务器信息未查到，请先配置')

        ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                 host_port=remote_server_info['server_ssh_port'],
                                 user_name=remote_server_info['server_user'],
                                 password=remote_server_info['server_password'])

        # 复制文件到待上传的目录

        upgrade_back_up_dir = os.path.join(temp_file_dir, 'backup', upgrade_no)

        with ssh_conenct as ssh:
            for files in os.listdir(upgrade_back_up_dir):
                path = os.path.join(upgrade_back_up_dir, files)
                ssh.upload(path, f'/huansi/upgrade/{files}')

            ssh.upload(os.path.join(system_file_dir, 'load.sh'), '/huansi/upgrade/load.sh')
            ssh.upload(os.path.join(system_file_dir, 'load_handle.py'), '/huansi/upgrade/load_handle.py')

            out, err = ssh.exec_command("echo 'sh /huansi/upgrade/load.sh'")

            logger.info(f'远程升级信息：{out}')

            if err:
                raise HSException(f'远程升级报错:\n{err}')

    def package_images(self, log_id):
        '''
        打包镜像
        :param log_id:
        :return:
        '''
        # 找到当前版本信息
        # 打包 到 /data下
        # 找到当前的版本信息

        upgrade_no = self.get_upgrade_no_by_log_id(log_id)

        self._package_images(upgrade_no)

        return {'message': '打包完成，请到D:\\HuanSi\\LinuxData\\upgrade查看'}

    def _package_images(self, upgrade_no):
        docker_compose_file_dir = self.find_compose_by_upgrade_no(upgrade_no)
        # 打包所有当前版本的所有app  到 /data下
        # 获取要升级的镜镜像名称
        deploy_image_list = self._get_deploy_image(docker_compose_file_dir)
        logger.info('要升级的镜像信息如下:\n{}'.format(deploy_image_list))
        if not os.path.exists('/data/upgrade'):
            os.mkdir('/data/upgrade')
        # 删除旧镜像
        os.system('rm -f /data/upgrade/*.tar')
        logger.info('开始生成镜像')
        for deploy_image in deploy_image_list:
            if not deploy_image:
                continue

            logger.info('        生成镜像:{}'.format(deploy_image))
            file_name = deploy_image.replace('/', '___').replace(':', '__') + '.tar'
            _cmd = 'docker save {} -o /data/upgrade/{}'.format(deploy_image, file_name)
            result = os.system(_cmd)
            if result == 1:
                raise RuntimeError("{}执行出错".format(_cmd))
        logger.info('镜像生成完毕,目录为/data/upgrade')

    def get_app_image_name_and_verison(self, app_image_name):
        '''
        获取镜像名和版本号
        :param app_image_name:
        :return:
        '''
        # 47.110.145.204:8084/huansi/hs_tools:1.1
        if ':' in app_image_name:
            _temp_str = app_image_name[::-1]
            image_version = _temp_str.slipt(':')[0][::-1]
            image_name = _temp_str[len(image_version) + 1:][::-1]
        else:
            image_name = app_image_name
            image_version = 'latest'
        return image_name, image_version

    def get_app_list_from_compose_file(self, docker_compose_file_dir):
        '''
        从compose文件中获取app_list
        :param docker_compose_file_dir:
        :return:
        '''
        with open(docker_compose_file_dir, 'r') as f:
            compose_content = f.read()

        app_list_str = re.findall('# app_list: "(.*)"', compose_content)
        if app_list_str:
            app_list_str = app_list_str[0]
        else:
            raise HSException('未能找到app_list')

        return app_list_str

    def _get_deploy_image(self, docker_compose_file_dir):
        '''
        获取要发布的镜像
        :param docker_compose_file_dir:
        :return:
        '''
        # 获取app_list
        with open(docker_compose_file_dir, 'r') as f:
            compose_content = f.read()

        app_list_str = re.findall('# app_list: "(.*)"', compose_content)
        if app_list_str:
            app_list_str = app_list_str[0]
        else:
            raise HSException('未能找到app_list')

        # 如果是*，返回所有镜像名
        # 如果是空，跳出
        if app_list_str == "":
            return None
        deploy_image_list = []
        if app_list_str == "*":
            image_list = re.findall(r'image: (.*)\n', compose_content)
            for image in image_list:
                _l = image.split(':')
                if len(_l) == 1:
                    tag = 'latest'
                else:
                    tag = _l[1]
                _image_info = '{}:{}'.format(_l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084'), tag)
                deploy_image_list.append(_image_info)
        else:
            app_list = app_list_str.split(' ')
            for app in app_list:
                image_info = re.findall(r'{}:(.*)\n(.*)image: (.*)\n'.format(app), compose_content)[0][-1:][0]
                _l = image_info.split(':')
                if len(_l) == 1:
                    tag = 'latest'
                else:
                    tag = _l[1]
                _image_info = '{}:{}'.format(_l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084'), tag)
                deploy_image_list.append(_image_info)

        return deploy_image_list

    def get_upgrade_no_by_log_id(self, log_id):
        '''
        获取升级编号
        :param log_id:
        :return:
        '''
        if not log_id:
            query_app_sql = 'select * from app_upgrade_log where default_version=1'
        else:
            query_app_sql = f'select * from app_upgrade_log where id={log_id}'

        with db_driver as session:
            app_info = session.retrive_sql(query_app_sql)

        if not app_info:
            raise HSException('未找到升级信息')

        upgrade_no = app_info['upgrade_no']

        return upgrade_no
