from flask import Flask
from huansi_utils.app.apploader import AppLoaderBase
from huansi_utils.db.sqlalchemy import db
from huansi_utils.flask_docs import ApiDoc

from flask_config import Config


class FlashAppLoader(AppLoaderBase):

    def init(self, app: Flask):
        app.config.from_object(Config)
        # 因为之前的基类不规范，到处引用，这样强行将import_name修改成当前文件
        app.import_name = 'flask_app'

    def register_blueprint(self, app):
        # 新版本api doc
        ApiDoc(app)

    def init_db(self, app):
        db.init_app(app)

    def register_webapi(self, app):
        from app import _webApi
        _webApi.init_app(app)


global_app = FlashAppLoader()()
