# -*- coding:utf-8 -*-

import os
import re

if __name__ == '__main__':
    with os.popen('ls | grep .tar') as f:
        cmd_txt = f.read()

    if not cmd_txt:
        raise RuntimeError('请检查文件,tar文件为空')

    app_name_list = cmd_txt.split('\n')

    for app_name in app_name_list:
        if not app_name:
            continue
        print('加载镜像:{}'.format(app_name[:-4].replace('___', "/").replace("__", ":")))
        cmd_res = os.system('docker load -i {}'.format(app_name))
        if cmd_res == 1:
            raise RuntimeError('加载失败')

    print('镜像加载完毕')
    print('开始升级程序')
    with open('docker-compose.yml', 'r') as f:
        compose_content = f.read()

    app_list_str = re.findall('# app_list: ".*"', compose_content)
    if app_list_str:
        app_list_str = app_list_str[0]
    else:
        raise RuntimeError('未设置app_list')

    app_str = app_list_str[len('# app_list: "'):-1]

    if app_str == '*':
        res = os.system('''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose up -p deploy -d --force-recreate''')
    else:
        res = os.system('''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose up -p deploy -d --force-recreate --no-deps {}'''.format(app_str))

    if res == 1: raise RuntimeError('程序升级失败')
