# -*- coding:utf-8 -*-
from flask import request

from app.application.application_service import ApplicationService
from huansi_utils.webapi import ApiController

from app import api
from app.authorization.authorization_service import AuthorizationService


@api('application')
class ApplicationAPI(ApiController):

    @api('<string:project_no>')
    def get_application_list(self, project_no):
        '''
        获取app列表
        :return:
        '''
        return ApplicationService().get_application_list(project_no)

    @api('<string:project_no>')
    def post_edit_application_setting(self, project_no):
        '''
        修改app列表
        :param project_no:
        :return:
        '''
        json_data_list = request.json.get('data')
        return ApplicationService().edit_application_list(project_no, json_data_list)

    @api('test_port/<string:project_no>')
    def get_port_list(self, project_no):
        '''
        获取端口号列表
        :param project_no:
        :return:
        '''
        return ApplicationService().get_port_list(project_no)

    @api('test_port/<string:project_no>')
    def post_port_list(self, project_no):
        '''
        批量测试端口
        :param project_no:
        :return:
        '''
        return ApplicationService().test_port(project_no, request.json)
