# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.authorization.authorization_service import AuthorizationService


@api('authorization')
class AuthorizationAPI(ApiController):
    @api()
    def get_session_info(self):
        '''
        获取session信息
        :return:
        '''
        return AuthorizationService().get_session_info()

    @api()
    def post_set_esssion_info(self):
        '''
        设置session信息
        :return:
        '''
        return AuthorizationService().set_esssion_info(request.json)

    @api('login')
    def post_login(self):
        '''
        登录
        :return:
        '''
        return AuthorizationService().login(request.json)
