# -*- coding:utf-8 -*-
import os
import re
import threading
from threading import Thread

from app.application.application_service import ApplicationService
from app.utils.thread_tools import ThreadTools
from huansi_utils.app.apploader import logger
from huansi_utils.exception.exception import HSException

from app.conncetion.conncetion_service import ConnectionService
from app.info.info_service import docker_client
from app.utils.db_tools import db_driver
from app.utils.ssh_tools import SSHConnect
from static_file import back_up_dir, builds_dir, temp_file_dir, system_file_dir, profile_dir


class UpgradeService():
    def rollback_upgrade(self, project_no, log_id):
        '''
        回滚升级
        :param log_id:
        :return:
        '''
        logger.info(f'开始回滚{log_id}......')
        # 找到对应版本
        with db_driver as session:
            # 当前版本不让回滚
            query_sql = f'''select * from app_upgrade_log where id={log_id}'''
            data = session.retrive_sql(query_sql)

            if data['default_version'] == '1':
                raise HSException('该版本已经是最新版本，不能进行回滚操作')

            # 找到记录的镜像信息
            sql = f'''select * from app_upgrade_log_dtl where log_id={log_id}'''
            image_info_list = session.query_sql(sql)

        # 找出升级版本号
        upgrade_no = data.get('upgrade_no')
        # 找到这个版本备份的compose文件
        docker_compose_file_dir = self.find_compose_by_upgrade_no(upgrade_no)

        # 挨个去找对应版本中的镜像然后逐一tag
        for image_info in image_info_list:
            app_image_id = image_info['app_image_id']
            app_image_name = image_info['app_image_name']

            # 系统中找镜像，如果镜像是None，重新tag，如果不是None，就不用处理了
            find_image_command = "docker images |grep " + app_image_id[:12] + " | awk '{print $2}'"
            with os.popen(find_image_command) as command:
                actual_image_verison = command.read()

            if not actual_image_verison:
                raise HSException(f'找不到对应的{app_image_id}的镜像')

            logger.info(f'镜像{app_image_id}的原镜像版本号为{actual_image_verison}')

            # tag它
            if actual_image_verison == '<none>':
                logger.info(f'tag镜像{app_image_id}为{app_image_name}')
                res = os.system(f'docker tag {app_image_id[:12]} {app_image_name}')
                if res == 1: raise HSException(f'Tag{app_image_name}镜像失败')
            else:
                # 有版本就不管
                pass
        # 找到app_list
        app_list = self.get_app_list_from_compose_file(docker_compose_file_dir)
        logger.info('compose中的app_list为:{}'.format(app_list))
        # docker-compose
        project_info = ConnectionService().get_project_info(project_no)
        host_ip = project_info['host_ip']
        # 调用本机的docker-compose
        ssh_conenct = SSHConnect(user_name='root', password='huansi.net', host_port='1111', host_ip=host_ip)
        with ssh_conenct as ssh:
            # 处理*的情况
            if app_list == '*':
                out, err = ssh.exec_command(
                    f'''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose -f /data/upgrade_tools_data/backup/{upgrade_no}/docker-compose.yml -p deploy up -d --force-recreate''')
            else:
                out, err = ssh.exec_command(
                    f'''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose -f /data/upgrade_tools_data/backup/{upgrade_no}/docker-compose.yml -p deploy up -d --force-recreate --no-deps {app_list}''')
            # 会有问题，docker-compose编译的时候，会把过程放到err上，所以注释这段
            # if err:
            #     raise HSException(f'回滚失败:{err}')
            if err:
                logger.info(f"有报错信息：{err}")
            logger.info(f'回滚{app_list}成功：{out}')

        with db_driver as session:
            # 对应的版本信息修改为当前版本
            session.exec_sql(f'update app_upgrade_log set default_version=1 where id={log_id}')
            session.exec_sql(f'update app_upgrade_log set default_version=0 where id<>{log_id}')

        return {'message': err, "out": out}
        # 注意异常情况下的处理

    def find_compose_by_upgrade_no(self, upgrade_no):
        '''
        找到这个版本备份的compose文件
        :param upgrade_no:
        :return:
        '''
        docker_compose_file_dir = os.path.join(back_up_dir, upgrade_no, 'docker-compose.yml')
        logger.info(f'备份的compose文件地址:{docker_compose_file_dir}')
        if not os.path.exists(docker_compose_file_dir):
            logger.info('远程升级失败')
            raise HSException(f'未找到{docker_compose_file_dir}')
        return docker_compose_file_dir

    def _remote_upgrade(self, project_no, work_shop_no, code_list_str):
        '''
        远程升级
        :param project_no:
        :return:
        '''
        from flask_app import global_app
        with global_app.app_context():
            from flask import g
            g.user = {}
            g.language = 'cn'
            upgrade_no = self.get_upgrade_no_by_log_id()

            # 校验远程服务器db有没有配置
            if not os.path.exists(os.path.join(profile_dir, 'huansi_server.sh')):
                logger.info('远程升级失败')
                raise HSException('服务器DB未配置，请先配置')

            # 找到服务器ip
            # 上传app包到服务器
            remote_server_info = ConnectionService().get_remote_server_info(project_no, work_shop_no)
            if not remote_server_info:
                logger.info('远程升级失败')
                raise HSException('远端服务器信息未查到，请先配置')

            ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                     host_port=remote_server_info['server_ssh_port'],
                                     user_name=remote_server_info['server_user'],
                                     password=remote_server_info['server_password'])

            # 复制文件到待上传的目录

            upgrade_back_up_dir = os.path.join(temp_file_dir, 'backup', upgrade_no)

            with ssh_conenct as ssh:
                # 验证远端服务器配置文件
                self.valdiate_remote_server_db_file(ssh, project_no, work_shop_no)

                # 验证远端服务器有没有按照docker
                self.validate_remote_server_install_docker(ssh)

                # 打包镜像
                self._package_images(upgrade_no, code_list_str)

                # 修改app_list
                docker_compose_file_dir = self.find_compose_by_upgrade_no(upgrade_no)

                with open(docker_compose_file_dir, 'r', encoding='utf8') as f:
                    compose_content = f.read()

                compose_content = re.sub('# app_list: "(.*)"', f'# app_list: "{code_list_str}"', compose_content)

                with open(docker_compose_file_dir, 'w', encoding='utf8') as f:
                    f.write(compose_content)

                logger.info('删除服务器上的旧镜像文件')
                ssh.exec_command('rm /huansi/upgrade/*.tar -f')

                for files in os.listdir(upgrade_back_up_dir):
                    path = os.path.join(upgrade_back_up_dir, files)
                    # 隐藏文件不复制
                    if files.startswith('.'):
                        continue
                    logger.info(f"地址：{path}---->/huansi/upgrade/{files}")
                    logger.info(f"现在没有卡住，是正在上传文件{files}，请耐心等待")
                    ssh.upload(path, f'/huansi/upgrade/{files}')
                    logger.info(f"地址：{path}上传完毕")

                    if '.tar' in path:
                        os.remove(path)
                        logger.info(f"本地缓存{path}已经清除")

                ssh.upload(os.path.join(system_file_dir, 'load.sh'), '/huansi/upgrade/load.sh')
                # 传入服务器配置的DB
                # 2.0版本的配置文件不是同时上传，需要分批上传
                # ssh.upload(os.path.join(profile_dir, 'huansi_server.sh'), '/huansi/upgrade/huansi.sh')
                ssh.upload(os.path.join(system_file_dir, 'load_handle.py'), '/huansi/upgrade/load_handle.py')

                logger.info('正在远程升级程序中，请不要着急，慢慢来。。。')
                logger.info('温馨提示：如果是第一次升级，会有点慢，但是不要担心是卡住了，更不要断网，这样会功亏一篑')
                logger.info('如果您还是担心卡住了，连上客户机的服务器上，输入docker images查看是否多了几个镜像（仅对第一次升级有用）')
                out, err = ssh.exec_command("sh /huansi/upgrade/load.sh")

                logger.info(f'远程升级信息：{out},远程错误信息：{out}')
                logger.info(f'远程升级成功')

                return {'message': '升级完成', out: err}

    def remote_upgrade(self, project_no, work_shop_no, code_list):
        '''
        远程升级
        :return:
        '''
        # 先去重
        if isinstance(code_list, list):
            code_list = list(set(code_list))
            code_list = [item.strip() for item in code_list]
            code_list_str = ' '.join(code_list)
        elif code_list == '*':
            code_list_str = '*'
        else:
            raise HSException('CODE不规范，请联系开发人员协助修复')

        # 每次只能有一个推送进程
        for thread_item in threading.enumerate():
            if not isinstance(thread_item, threading.Thread):
                continue

            if thread_item.name == 'remote_upgrade':
                logger.info('发现之前一个线程正在处理，杀死它，重新启动')
                # 停止线程
                ThreadTools().stop_thread(thread_item)

        t = Thread(target=self._remote_upgrade, args=(project_no, work_shop_no, code_list_str), name='remote_upgrade')
        t.start()

        return {"message": "开始远程升级"}

    def package_images(self, log_id):
        '''
        打包镜像
        :param log_id:
        :return:
        '''
        # 找到当前版本信息
        # 打包 到 /data下
        # 找到当前的版本信息

        upgrade_no = self.get_upgrade_no_by_log_id(log_id)

        self._package_images(upgrade_no)

        return {'message': f'打包完成，请到D:\\HuanSi\\LinuxData\\upgrade\\upgrade_tools_data\\backup\\{upgrade_no}查看'}

    def _package_images(self, upgrade_no, code_list_str=None):
        docker_compose_file_dir = self.find_compose_by_upgrade_no(upgrade_no)
        # 打包所有当前版本的所有app  到 /data下
        # 获取要升级的镜镜像名称
        deploy_image_list = self._get_deploy_image(docker_compose_file_dir, app_list_str=code_list_str)
        logger.info('要升级的镜像信息如下:\n{}'.format(deploy_image_list))

        upgrade_no_back_up_dir = os.path.join(back_up_dir, upgrade_no)

        if not os.path.exists(upgrade_no_back_up_dir):
            raise HSException(f'{upgrade_no_back_up_dir}找不到')
        # 删除旧镜像
        os.system(f'rm -f {upgrade_no_back_up_dir}/*.tar')
        logger.info('开始生成镜像')
        for deploy_image in deploy_image_list:
            if not deploy_image:
                continue

            logger.info('        生成镜像:{}'.format(deploy_image))
            file_name = deploy_image.replace('/', '___').replace(':', '__') + '.tar'
            _cmd = 'docker save {} -o {}/{}'.format(deploy_image, upgrade_no_back_up_dir, file_name)
            result = os.system(_cmd)
            if result != 0:
                logger.info('远程升级失败')
                raise RuntimeError("{}执行出错".format(_cmd))
        logger.info(f'镜像生成完毕,目录为{upgrade_no_back_up_dir}')

    def get_app_image_name_and_verison(self, app_image_name):
        '''
        获取镜像名和版本号
        :param app_image_name:
        :return:
        '''
        # 47.110.145.204:8084/huansi/hs_tools:1.1
        if ':' in app_image_name:
            _temp_str = app_image_name[::-1]
            image_version = _temp_str.slipt(':')[0][::-1]
            image_name = _temp_str[len(image_version) + 1:][::-1]
        else:
            image_name = app_image_name
            image_version = 'latest'
        return image_name, image_version

    def get_app_list_from_compose_file(self, docker_compose_file_dir):
        '''
        从compose文件中获取app_list
        :param docker_compose_file_dir:
        :return:
        '''
        with open(docker_compose_file_dir, 'r') as f:
            compose_content = f.read()

        app_list_str = re.findall('# app_list: "(.*)"', compose_content)
        if app_list_str:
            app_list_str = app_list_str[0]
        else:
            logger.info('远程升级失败')
            raise HSException('未能找到app_list')

        return app_list_str

    def _get_deploy_image(self, docker_compose_file_dir, app_list_str=None):
        '''
        获取要发布的镜像
        :param docker_compose_file_dir:
        :return:
        '''
        # 获取app_list
        with open(docker_compose_file_dir, 'r') as f:
            compose_content = f.read()
        if app_list_str is None:
            app_list_str = re.findall('# app_list: "(.*)"', compose_content)
            if app_list_str:
                app_list_str = app_list_str[0]
            else:
                logger.info('远程升级失败')
                raise HSException('未能找到app_list')

        # 如果是*，返回所有镜像名
        # 如果是空，跳出
        if app_list_str == "":
            return None
        deploy_image_list = []
        if app_list_str == "*":
            image_list = re.findall(r'image: (.*)\n', compose_content)
            for image in image_list:
                # 要考虑直接输入ip的情况
                if '47.110.145.204:8084' in image:
                    image = image.replace('47.110.145.204:8084', '${HUANSI_REGISTRY_URL}')

                _l = image.split(':')
                if len(_l) == 1:
                    tag = 'latest'
                else:
                    tag = _l[1]
                _image_info = '{}:{}'.format(_l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084'), tag)
                deploy_image_list.append(_image_info)
        else:
            app_list = app_list_str.split(' ')
            for app in app_list:
                # 要考虑直接输入ip的情况
                if '47.110.145.204:8084' in app:
                    app = app.replace('47.110.145.204:8084', '${HUANSI_REGISTRY_URL}')

                image_info = re.findall(r'{}:(.*)\n(.*)image: (.*)\n'.format(app), compose_content)[0][-1:][0]
                _l = image_info.split(':')
                if len(_l) == 1:
                    tag = 'latest'
                else:
                    tag = _l[1]
                _image_info = '{}:{}'.format(_l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084'), tag)
                deploy_image_list.append(_image_info)

        return deploy_image_list

    def get_upgrade_no_by_log_id(self, log_id=None):
        '''
        获取升级编号
        :param log_id:
        :return:
        '''
        if not log_id:
            query_app_sql = 'select * from app_upgrade_log where default_version=1'
        else:
            query_app_sql = f'select * from app_upgrade_log where id={log_id}'

        with db_driver as session:
            app_info = session.retrive_sql(query_app_sql)

        if not app_info:
            logger.info('远程升级失败')
            raise HSException('未找到升级信息')

        upgrade_no = app_info['upgrade_no']

        return upgrade_no

    def validate_remote_server_install_docker(self, ssh):
        '''
        验证远端服务器是否安装docker
        :param ssh:
        :return:
        '''
        out, err = ssh.exec_command('docker -v')

        if 'Docker version' not in out:
            logger.info('验证远端服务器是否安装docker日志:{}'.format(err))
            logger.info('远程升级失败')
            raise HSException('远端服务器未安装docker，请先安装后再升级')

    def valdiate_remote_server_db_file(self, ssh, project_no, work_shop_no):
        '''
        验证远端服务器配置文件
        :param ssh:
        :return:
        '''
        out, err = ssh.exec_command('cat /huansi/upgrade/huansi.sh')

        if err:
            logger.info('温馨提示：现在的模式为配置文件和app分开上传，防止手误导致客户服务器配置出错，一车间的程序连到二车间的数据库，所以升级之前要先上传配置文件')
            logger.info('远程升级失败')
            raise HSException('服务器配置文件未上传，升级之前要先上传配置文件')

        else:
            data = out.replace('export ', '')

            data_item_list = data.split('\n')

            server_project_no = ''
            server_work_shop_no = 'unknown'
            for data_item in data_item_list:
                _l = data_item.split('=')
                if _l[0] == 'HSCUSCODE':
                    server_project_no = _l[1]
                if _l[0] == 'WORK_SHOP_NO':
                    server_work_shop_no = _l[1]

            if project_no != server_project_no or work_shop_no != server_work_shop_no:
                logger.info('远程升级失败')
                raise HSException('服务器和本地的配置文件信息对应不上，请检查后再上传配置文件')

    def apply_db_setting(self, project_no):
        '''
        应用数据库db配置
        :return:
        '''
        if not os.path.exists(os.path.join(profile_dir, 'huansi.sh')):
            raise HSException('请先配置数据库信息')

        query_app_sql = 'select * from app_upgrade_log where default_version=1'

        with db_driver as session:
            app_info = session.retrive_sql(query_app_sql)

        if not app_info:
            raise HSException('未查询到本机有升级信息，不用应用修改')
        else:
            upgrade_no = app_info['upgrade_no']

        project_info = ConnectionService().get_project_info(project_no)
        host_ip = project_info['host_ip']
        # 调用本机的docker-compose
        ssh_conenct = SSHConnect(user_name='root', password='huansi.net', host_port='1111', host_ip=host_ip)
        with ssh_conenct as ssh:
            out, err = ssh.exec_command(
                f'''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /etc/profile.d/huansi.sh &&\
docker-compose -f /data/upgrade_tools_data/backup/{upgrade_no}/docker-compose.yml -p deploy up -d --force-recreate''')

            logger.info(f'应用操作信息:{out},其他信息:{err}')
            logger.info("应用修改成功")

    def upload_remote_server_db(self, project_no, work_shop_no):
        '''
        上传远程服务器数据库配置文件
        :param project_no:
        :return:
        '''
        if work_shop_no == 'unknown':
            logger.info('远程升级失败')
            raise HSException('车间名不合法')

        conncetion_service = ConnectionService()
        # 按project_no切换配置文件
        remote_db_info = conncetion_service.get_remote_db_info(project_no, work_shop_no, sync_file=True)
        # 测试数据库连接是否正确
        test_c_result = conncetion_service.test_connection(remote_db_info)
        if test_c_result['message'] == '连接失败':
            logger.info('远程升级失败')
            raise HSException('数据库连接失败')
        # 查询远程配置信息
        remote_server_info = conncetion_service.get_remote_server_info(project_no, work_shop_no)
        # 上传文件
        if not remote_server_info:
            logger.info('远程升级失败')
            raise HSException('远端服务器信息未查到，请先配置')

        ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                 host_port=remote_server_info['server_ssh_port'],
                                 user_name=remote_server_info['server_user'],
                                 password=remote_server_info['server_password'])

        with ssh_conenct as ssh:
            # 新建目录
            ssh.exec_command('mkdir -p /huansi/upgrade/')
            ssh.upload(os.path.join(profile_dir, 'huansi_server.sh'), '/huansi/upgrade/huansi.sh')

        return {'message': '上传成功'}

    def get_compare_image_info(self, project_no, work_shop_no):
        '''
        获取服务器和本地要推送的镜像对比
        :param project_no:
        :return:
        '''
        conncetion_service = ConnectionService()
        # 查询远程配置信息
        remote_server_info = conncetion_service.get_remote_server_info(project_no, work_shop_no)
        # 上传文件
        if not remote_server_info:
            logger.info('远程升级失败')
            raise HSException('远端服务器信息未查到，请先配置')

        ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                 host_port=remote_server_info['server_ssh_port'],
                                 user_name=remote_server_info['server_user'],
                                 password=remote_server_info['server_password'])

        with ssh_conenct as ssh:
            out, err = ssh.exec_command('docker images --format "table {{.ID}}\t{{.Repository}}\t{{.Tag}}"')
            server_image_list = self.convert_image_info_str_to_list(out)

        # 本地机制
        # 取compose中的所有app
        application_service = ApplicationService()
        application_service.checkout(project_no)
        compose_content = application_service.get_compose_content()

        deploy_image_list = []
        image_info_list = re.findall(r' (.*):\r*\n *image: (.*)\n', compose_content)
        for image_info in image_info_list:
            code = image_info[0]
            image = image_info[1]
            # 要考虑直接输入ip的情况
            if '47.110.145.204:8084' in image:
                image = image.replace('47.110.145.204:8084', '${HUANSI_REGISTRY_URL}')

            _l = image.split(':')
            if len(_l) == 1:
                tag = 'latest'
            else:
                tag = _l[1]
            # 划分app镜像名和版本号
            _image_info = {}
            _image_info['name'] = _l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084')
            _image_info['tag'] = tag
            _image_info['code'] = code
            deploy_image_list.append(_image_info)
        # 本地镜像获取
        with os.popen('docker images --format "table {{.ID}}\t{{.Repository}}\t{{.Tag}}"') as f:
            local_image_info = f.read()
        local_app_list = self.convert_image_info_str_to_list(local_image_info)
        # 根据镜像名和版本号过滤本地镜像
        filter_app_list = []
        for local_app in local_app_list:
            filter_app = {}
            app_id = local_app['id']
            app_name = local_app['name']
            app_tag = local_app['tag']
            for deploy_image in deploy_image_list:
                image_name = deploy_image['name']
                image_tag = deploy_image['tag']
                code = deploy_image['code']

                if app_tag == image_tag and app_name == image_name:
                    filter_app['tag'] = app_tag
                    filter_app['id'] = app_id
                    filter_app['name'] = app_name
                    filter_app['code'] = code
                    break
            if filter_app:
                filter_app_list.append(filter_app)
        print(filter_app_list)
        # 在和服务器的做对比
        result_list = []
        for server_image in server_image_list:
            result_dict = {}
            server_image_id = server_image['id']
            server_image_name = server_image['name']
            server_image_tag = server_image['tag']
            for filter_app in filter_app_list:
                filter_app_id = filter_app['id']
                filter_app_name = filter_app['name']
                filter_app_tag = filter_app['tag']
                filter_app_code = filter_app['code']
                if server_image_name == filter_app_name:
                    result_dict['server_id'] = server_image_id
                    result_dict['server_name'] = server_image_name
                    result_dict['server_tag'] = server_image_tag
                    result_dict['local_id'] = filter_app_id
                    result_dict['local_name'] = filter_app_name
                    result_dict['local_tag'] = filter_app_tag
                    result_dict['code'] = filter_app_code
                    break
            else:
                result_dict['server_id'] = server_image_id
                result_dict['server_name'] = server_image_name
                result_dict['server_tag'] = server_image_tag
                result_dict['code'] = ''
                result_dict['local_id'] = ''
                result_dict['local_name'] = ''
                result_dict['local_tag'] = ''

            # 只赋值code有值的数据
            if result_dict.get('code'):
                result_list.append(result_dict)

        for filter_app in filter_app_list:
            result_dict = {}
            filter_app_id = filter_app['id']
            filter_app_name = filter_app['name']
            filter_app_tag = filter_app['tag']
            filter_app_code = filter_app['code']
            for server_image in server_image_list:
                server_image_name = server_image['name']

                if server_image_name == filter_app_name:
                    break
            else:
                result_dict['server_id'] = ''
                result_dict['server_name'] = ''
                result_dict['server_tag'] = ''
                result_dict['local_id'] = filter_app_id
                result_dict['local_name'] = filter_app_name
                result_dict['local_tag'] = filter_app_tag
                result_dict['code'] = filter_app_code

            # 只赋值code有值的数据
            if result_dict and result_dict.get('code'):
                result_list.append(result_dict)
        return result_list

    def convert_image_info_str_to_list(self, image_info_str):
        '''
        将命令docker images --format "table {{.ID}}\t{{.Repository}}\t{{.Tag}}"的结果转换为数组
        :param image_info_str:
        :return:
        '''
        image_info_str = image_info_str.replace('\r', '')
        server_image_str_list = image_info_str.split('\n')[1:]
        image_info_list = []
        for server_image_str in server_image_str_list:
            if not server_image_str:
                continue
            _l = re.findall('(\S+) +(\S+) +(\S+)', server_image_str)[0]
            if _l[2] == '<none>':
                continue

            image_info = {}
            image_info['id'] = _l[0]
            image_info['name'] = _l[1]
            image_info['tag'] = _l[2]
            image_info_list.append(image_info)

        return image_info_list
