# -*- coding:utf-8 -*-
import os

from func_timeout import func_set_timeout, FunctionTimedOut

from huansi_utils.app.apploader import logger
from huansi_utils.exception.exception import HSException


def time_out(fn, *args, **kwargs):
    def wrapper(*args, **kwargs):
        try:
            result = fn(*args, **kwargs)
            return result
        except FunctionTimedOut:
            print('timeout')
            return False

    return wrapper


class CommonTools:
    @classmethod
    def validate_dict_value_all_not_none(cls, dict_data: dict, mapping=None):
        '''
        验证字典的值全不为空
        :return:
        '''
        if not isinstance(dict_data, dict):
            raise HSException('dict_data必须为字典类型')

        for key, value in dict_data.items():
            if value is None:
                raise HSException(f"{key}不能为空")

    # 超过四秒，基本上没救了，告辞~~~~
    # @timeout_decorator.timeout(2)
    @time_out
    @func_set_timeout(2)
    def test_db_connection(self, ip: int, port: int, user_name: str, password: str, db_name: str):
        '''
        测试数据库连接
        :param ip:
        :param port:
        :param user_name:
        :param password:
        :param db_name:
        :param sql:
        :return:
        '''
        from sqlalchemy import create_engine
        from sqlalchemy.orm import sessionmaker

        con_str = f'mssql+pymssql://{user_name}:{password}@{ip}:{port}/{db_name}'

        engine = create_engine(con_str)

        DBSession = sessionmaker(bind=engine)

        try:
            session = DBSession()

            result = session.execute("select test='huansi'")

            data = result.fetchone()

            if data.test == 'huansi':
                return True
            else:
                return False

        except Exception as e:
            from func_timeout import FunctionTimedOut
            if isinstance(e, FunctionTimedOut):
                logger.error("数据库连接失败，失败原因：{}".format(e))
                return False
            orig = getattr(e, 'orig')
            args = getattr(orig, 'args', ((),))[0]
            error_message = ''
            for e_item in args:
                if isinstance(e_item, bytes):
                    try:
                        e_item = e_item.decode()
                    except:
                        e_item = str(e_item)
                error_message += str(e_item)

            if not error_message:
                error_message = str(e)

            logger.error("数据库连接失败，失败原因：{}".format(error_message))

            return False

    @classmethod
    def validate_runner_is_install(self):
        '''
        验证runner是否成功安装
        :return:
        '''
        runner_file_path = '/etc/gitlab-runner/config.toml'
        if not os.path.exists(runner_file_path):
            raise HSException('没有安装runner')
