import os
import shutil
import stat
import time

import git
from flask import Flask
from huansi_utils.app.apploader import AppLoaderBase, logger
from huansi_utils.db.sqlalchemy import db
from huansi_utils.flask_docs import ApiDoc

from flask_config import Config
from static_file import temp_file_dir

deploy_repo_path = 'ssh://git@47.110.145.204:2222/hs/deploy.git'

git_path = os.path.join(temp_file_dir, 'deploy')


# 初始化git仓库
# if not os.path.exists(os.path.join(git_path, '.git')):
#     # docker环境线下老是出现问题，先用代码拉取
#     os.system(f'git clone {deploy_repo_path} {git_path}')
#     # repo = git.Repo.clone_from(url=deploy_repo_path, to_path=git_path)
#
# repo = git.Repo(git_path)
# repo.git.pull()

# 初始化git仓库(部分机子无法使用上次缓存的项目，直接删除上传缓存，每次都重新下载)
def readonly_handler(func, path, execinfo):
    '''
    在path目录下的部分文件或目录是只读的，从而会导致该操作失败，
    需要在操作出错的时候，将文件或文件夹的状态修改为支持写的模式。
    这里需要使用shutil.rmtree的onerror这个参数，
    这里需要实现文件权限修改的回调函数，通过onerror带入。
    '''
    os.chmod(path, stat.S_IWRITE)
    time.sleep(0.5)
    func(path)

if os.path.exists(git_path):
    shutil.rmtree(git_path, onerror=readonly_handler)

# docker环境线下老是出现问题，先用代码拉取
os.system(f'git clone {deploy_repo_path} {git_path}')
repo = git.Repo(git_path)


class FlashAppLoader(AppLoaderBase):

    def init(self, app: Flask):
        app.config.from_object(Config)
        # 因为之前的基类不规范，到处引用，这样强行将import_name修改成当前文件
        app.import_name = 'flask_app'
        from app.utils.db_tools import db_driver, create_table_sql_list
        with db_driver as session:
            for create_table_sql in create_table_sql_list:
                session.exec_sql(create_table_sql)

            # 增加字段
            try:
                session.retrive_sql('select work_shop_no from remote_server_info')
            except Exception as e:
                logger.info(f'兼容表结构报错:{e}')
                session.exec_sql('ALTER TABLE remote_server_info ADD COLUMN work_shop_no varchar(50)')

        # 兼容之前的db配置
        from app.conncetion.conncetion_service import ConnectionService
        ConnectionService().sync_remote_db_info()

    def register_blueprint(self, app):
        # 新版本api doc
        ApiDoc(app)

    def init_db(self, app):
        db.init_app(app)

    def register_webapi(self, app):
        from app import _webApi
        _webApi.init_app(app)


global_app = FlashAppLoader()()
