import time
import hashlib
import requests

import celery_config

class DefaultAuth:
    def __init__(self, to):
        self.sync_data_api = celery_config.API[to]['sync_data_api']
        try:
            self.sync_back_api = celery_config.API[to]['sync_back_api']
        except KeyError:
            pass
        self.key = celery_config.API[to]['auth_key']
        self.key_name = celery_config.API[to]['auth_key_name']

    def auth(self):
        return {'Content-Type': 'application/json'}

    def send_data(self, data):
        '''
        发送数据
        :param data:数据包
        :return:
        '''
        headers = {}
        headers.update(self.auth())
        requests.post(
            url=self.sync_back_api if 'state' in data else self.sync_data_api,
            headers=headers,
            json=data
        )


class ErpAuth(DefaultAuth):

    def auth(self):
        """
        如需要接口认证,可自定义认证规则
        :return:
        """
        # ha = hashlib.md5(cls.key.encode('utf-8'))
        # time_span = time.time()
        # ha.update(bytes("%s|%f" % (cls.key, time_span), encoding='utf-8'))
        # encryption = ha.hexdigest()
        # result = "%s|%f" % (encryption, time_span)
        # return {cls.key_name: result, 'Content-Type': 'application/json'}
        return {'Content-Type': 'application/json'}
