import json
import unittest
from flask import request
from huansi_utils.app.apploader import AppLoaderBase

global_app = AppLoaderBase()()


class test_xml_response(unittest.TestCase):
    '''
    flask支持xml请求测试用例
    '''

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_xml_get_json_from_xml_header(self):
        '''
        测试get_json获取xml数据
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = "<note><name>黄天霸</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json()
            print('解析后的数据:', rt)
            self.assertIsInstance(rt, dict, "解析失败，返回数据不为字典格式")
            self.assertIsInstance(rt['note'], dict, "解析失败，返回数据<note>节点不为字典格式")
            self.assertEqual(rt['note']['name'], "黄天霸")

    def test_xml_get_json_from_xml_header_two(self):
        '''
        测试get_json获取xml数据
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<?xml version="1.0" encoding="utf-8"?>
<note>
    <name>黄天霸</name>
</note>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json()
            print('解析后的数据:', rt)
            self.assertIsInstance(rt, dict, "解析失败，返回数据不为字典格式")
            self.assertIsInstance(rt['note'], dict, "解析失败，返回数据<note>节点不为字典格式")
            self.assertEqual(rt['note']['name'], "黄天霸")

    def test_xml_get_json_from_xml_list_header(self):
        '''
        测试get_json获取xml数据 列表xml数据
        :return:
        '''
        test_headers1 = {"content-type": "application/xml"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers1):
            rt = request.get_json()
            print('解析后的数据:', rt)
            self.assertIsInstance(rt['note']['name'], list, "解析失败，未能解析成list数据")

    def test_xml_get_json_from_json_header(self):
        '''
        测试get_json获取xml数据 json格式头表 xml体
        :return:
        '''
        test_headers2 = {"content-type": "application/json"}
        test_data1 = "<note><name>黄天霸</name></note>"

        # json头信息下测试
        with global_app.test_request_context('/login', method='POST', data=test_data1, headers=test_headers2):
            try:
                rt = request.get_json()
            except Exception as e:
                print("错误信息:", e)
                rt = None
            print('解析后的数据:', rt)
            self.assertIsNone(rt, "这都不为None,肯定有问题")

    def test_xml_get_json_from_json_list_header(self):
        '''
        测试get_json获取xml数据 json格式头表 xml体
        :return:
        '''
        test_headers2 = {"content-type": "application/json"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers2):
            try:
                rt = request.get_json()
            except Exception as e:
                print("错误信息:", e)
                rt = None
            print('解析后的数据:', rt)
            self.assertIsNone(rt, "这都不为None,肯定有问题")

    def test_get_accept_xml_response_by_dict(self):
        '''
        测试accept为xml的response 字典
        :return:
        '''
        from huansi_utils.webapi.HSWebApi import HSWebApi
        _webApi = HSWebApi("api", __name__)
        _webApi.init_app(global_app)

        test_headers2 = {"content-type": "application/xml", "accept": "application/xml"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers2):
            test_data = {"note": {"name": "黄天霸"}}
            rv = _webApi.make_response(test_data, 200)
            rv_data = str(rv.data, encoding='utf8')

            print("test_get_accept_xml_response_by_dict Response的内容:", rv_data)
            self.assertIn("</note>", rv_data, "找不到</note>节点")

    def test_get_accept_xml_response_by_str(self):
        '''
        测试accept为xml的response 字符串
        :return:
        '''
        from huansi_utils.webapi.HSWebApi import HSWebApi
        _webApi = HSWebApi("api", __name__)
        _webApi.init_app(global_app)

        test_headers2 = {"content-type": "application/xml", "accept": "application/xml"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers2):
            test_data = "吾乃黄田坝"
            rv = _webApi.make_response(test_data, 200)
            rv_data = str(rv.data, encoding='utf8')

            print("test_get_accept_xml_response_by_str Response的内容:", rv_data)
            self.assertEqual("吾乃黄田坝", test_data)

    def test_get_accept_json_response_by_dict(self):
        '''
        测试accept为json的response 字典
        :return:
        '''
        from huansi_utils.webapi.HSWebApi import HSWebApi
        _webApi = HSWebApi("api", __name__)
        _webApi.init_app(global_app)

        test_headers2 = {"content-type": "application/xml", "accept": "application/json"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers2):
            test_data = {"note": {"name": "黄天霸"}}
            rv = _webApi.make_response(test_data, 200)
            # rv_data = str(rv.data, encoding='utf8')

            print("test_get_accept_json_response_by_dict Response的内容:", rv.json)
            self.assertTrue(rv.is_json)

    def test_get_accept_xml_response_by_dict_two(self):
        '''
        测试accept为json的response 字典
        :return:
        '''
        from huansi_utils.webapi.HSWebApi import HSWebApi
        _webApi = HSWebApi("api", __name__)
        _webApi.init_app(global_app)

        test_headers2 = {"content-type": "application/xml", "accept": "application/xml"}
        test_data2 = "<note><name>黄天霸</name><name>黄天霸二号</name></note>"

        with global_app.test_request_context('/login', method='POST', data=test_data2, headers=test_headers2):
            test_data = {"name": "黄天霸", "age": "60", "language": ["english", "chinese"]}
            rv = _webApi.make_response(test_data, 200)
            rv_data = str(rv.data, encoding='utf8')

            print("test_get_accept_json_response_by_dict_two Response的内容:", rv_data)
            self.assertIn("<data>", rv_data)

    def test_get_json_from_property_xml(self):
        '''
        测试property XML
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<A sScreenId="1136108587089793024" sScreenNo="9385" sScreenName="5015"><aa>aa</aa></A>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json()
            json_data = json.dumps(rt)
            print('解析后的数据:', json_data)
            self.assertEqual(json_data,
                             '''{"A": {"sScreenId": "1136108587089793024", "sScreenNo": "9385", "sScreenName": "5015", "aa": "aa"}}''')

    def test_get_json_from_property_xml_two(self):
        '''
        测试property XML
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<B><A sScreenId="1136108587089793024" sScreenNo="9385" sScreenName="5015"><aa>aa</aa></A></B>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json()
            json_data = json.dumps(rt)
            print('解析后的数据:', json_data)
            self.assertEqual(json_data,
                             '''{"B": {"A": {"sScreenId": "1136108587089793024", "sScreenNo": "9385", "sScreenName": "5015", "aa": "aa"}}}''')

    def test_get_json_from_property_xml_three(self):
        '''
        测试property XML
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<B><A sScreenId="1136108587089793024" sScreenNo="9385" sScreenName="5015"><aa>aa</aa></A></B>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json(node_list_str="B")
            json_data = json.dumps(rt)
            print('解析后的数据:', json_data)
            self.assertEqual(json_data,
                             '''[{"A": {"sScreenId": "1136108587089793024", "sScreenNo": "9385", "sScreenName": "5015", "aa": "aa"}}]''')

    def test_get_json_from_property_xml_four(self):
        '''
        测试property XML
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<B><A sScreenId="1136108587089793024" sScreenNo="9385" sScreenName="5015"><aa>aa</aa></A></B>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json(node_list_str="A")
            json_data = json.dumps(rt)
            print('解析后的数据:', json_data)
            self.assertEqual(json_data,
                             '''{"B": {"A": [{"sScreenId": "1136108587089793024", "sScreenNo": "9385", "sScreenName": "5015", "aa": "aa"}]}}''')

    def test_get_json_from_property_xml_five(self):
        '''
        测试property XML
        :return:
        '''
        test_headers = {"content-type": "application/xml"}
        test_data = '''<B><A sScreenId="1136108587089793024" sScreenNo="9385" sScreenName="5015"><aa>aa</aa></A></B>'''

        with global_app.test_request_context('/login', method='POST', data=test_data, headers=test_headers):
            rt = request.get_json(node_list_str="B,A")
            json_data = json.dumps(rt)
            print('解析后的数据:', json_data)
            self.assertEqual(json_data,
                             '''[{"A": [{"sScreenId": "1136108587089793024", "sScreenNo": "9385", "sScreenName": "5015", "aa": "aa"}]}]''')


if __name__ == '__main__':
    unittest.main()
