# -*- coding:utf-8 -*-

compose_content='''version: "3"
# app_list: "*"
# ip: "172.17.0.1"

services:
  # {"app_code":"Portainer","app_name":"Docker可视化管理工具","web_port":23001}
  portainer:
    image: portainer/portainer
    restart: always
    volumes:
      - "/var/run/docker.sock:/var/run/docker.sock"
      - "/data/portainer_data:/data"
    container_name: portainer
    ports:
      - "9000:9000"
    
  # {"app_code":"Tool","id":"8","app_name":"环思工具集","api_port":23280,"api_version":"1.2"}
  hs_tools:
    image: ${HUANSI_REGISTRY_URL}/huansi/hs_tools:1.2
    restart: always
    depends_on:
     - huansi_mq
     - huansi_redis
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      REDIS_HOST: huansi_redis
      REDIS_PORT: 6379
      REDIS_PWD: "huansi.net"
      REDIS_DB: 0
      WHITE_LIST: "['*']"
      HS_RABBITMQ_HOST: huansi_mq
      HS_RABBITMQ_PORT: 5672
      HS_RABBITMQ_USERNAME: "huansi"
      HS_RABBITMQ_PASSWORD: "huansi.net"
      HS_RABBITMQ_START: "True"
      HSRIGHT_RPC: "huansi_right_api:8120"
      PROXY_URL: "huansi_nginx:80"
      RPC_PROXY_URL: "huansi_nginx:81"
      RPC_PORT: "8120"
      THREADS: 100 #请求线程数
      WORKER: 1 #请求进程数
    volumes:
      - "/data/nginx/conf/:/huansi_app/static_file/conf/nginx"
      - "/data/hs_tools/static_file/log:/huansi_app/static_file/log"
    ports:
      - "23280:23280"
      - "8117:8120"
    networks:
      - huansi_nets
    container_name: hs_tools

  # {"app_code":"Redis","app_name":"Redis服务","api_port":23283}
  huansi_redis:
    image: ${HUANSI_REGISTRY_URL}/huansi/redis:latest
    restart: always
    volumes:
      - "/data/redis/data:/data"
    ports:
      - "23283:6379"
    networks:
      - huansi_nets
    command: redis-server --appendonly yes --requirepass "huansi.net"
    container_name: huansi_redis

  # {"app_code":"RabbitMQ","app_name":"RabbitMQ服务","web_port":23281,"api_port":23282,"api_port2":8140}
  huansi_mq:
    image: ${HUANSI_REGISTRY_URL}/huansi/mq:latest
    restart: always
    hostname: my-rabbit
    ports:
      - "23281:15672"
      - "23282:5672"
      - "8140:15674"
    environment:
      RABBITMQ_DEFAULT_USER: huansi
      RABBITMQ_DEFAULT_PASS: huansi.net
    expose:
      - "15672"
      - "5672"
      - "8140"
    networks:
      - huansi_nets
    container_name: huansi_mq

  # {"app_code":"Right","id":"36","app_name":"HSRight","web_port":23287,"web_version":"1.2"}
  huansi_right_web:
    image: ${HUANSI_REGISTRY_URL}/huansi/hs_right_web:1.2
    restart: always
    depends_on:
      - huansi_right_api
    ports:
      - "23287:8000"
    environment:
      API: "http://huansi_right_api:8080"
      PORT: 8000
      PROXY_URL: "huansi_nginx:80"
    container_name: huansi_right_web
    networks:
      - huansi_nets

  # {"app_code":"Right","id":"36","app_name":"HSRight","api_port":23288,"api_port2":23289,"api_version":"1.2"}
  huansi_right_api:
    image: ${HUANSI_REGISTRY_URL}/huansi/hs_right_api:1.2
    restart: always
    volumes:
      - "/data/hs_right/static_file/log:/huansi_app/static_file/log"
    ports:
      - "23288:8080"
      - "23289:8120"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "HSRight"   
      REDIS_HOST: huansi_redis
      REDIS_PORT: 6379
      REDIS_DB: "1"
      REDIS_PWD: "huansi.net"
      PROXY_URL: "huansi_nginx"
    container_name: huansi_right_api

    expose:
      - "8080"
    networks:
      - huansi_nets

  # {"app_code":"RollCall","id":"81","app_name":"管控点名","api_port":23271,"api_version":"1.1"}
  rollcall_api:
    image: ${HUANSI_REGISTRY_URL}/huansi/rollcall_api:1.1
    restart: always
    volumes:
      - "/data/rollcall/static_file:/app/static_file"
    ports:
      - "23271:8080"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      HS_RABBITMQ_HOST: huansi_mq
      HS_RABBITMQ_PORT: 5672
      HS_RABBITMQ_USERNAME: "huansi"
      HS_RABBITMQ_PASSWORD: "huansi.net"
      REDIS_HOST: huansi_redis
      REDIS_PORT: 6379
      REDIS_DB: "4"
      REDIS_PWD: "huansi.net"
      # ROLL_CALL_API: "http://10.10.225.252:10103"   # 工位机点名无需配置，池久点名需要配置
      ROLL_CALL_SECOND: 60
      TOOL_CHECK_SECOND: 60
      ROLLCALL_START_VOICE_TIMES: 3
      ROLLCALL_START_SECOND_VOICE_TIMES: 2
      ROLLCALL_FINISH_VOICE_TIMES: 3
      PROXY_URL: "huansi_nginx"
    container_name: rollcall_api
    expose:
      - "8080"
    networks:
      - huansi_nets
      
  #  WEB BI通用看板
  # {"app_code":"BoardBI","id":"161","app_name":"BI通用看板","web_port":23392,"web_version":"1.4"}
  board_bi_web:
    image: ${HUANSI_REGISTRY_URL}/huansi/board_bi_web:1.4
    restart: always
    ports:
      - "23392:8000"
    environment:
      API: "http://hs_tools:23280"
      UPLOADAPI: "HTTP://file_resource_api:8080"
      PORT: 8000
      PROXY_URL: "huansi_nginx:80"
    container_name: board_bi_web
    networks:
      - huansi_nets

  # {"app_code":"WebboardWeb","id":"8789","app_name":"车间大屏","web_port":23273,"web_version":"1.3"}
  webboard_web:
    image: 47.110.145.204:8084/huansi/webboard_web:1.3
    restart: always
    depends_on:
      - hs_tools
      - rollcall_api
      - file_resource_api
    ports:
      - "23273:8000"
    environment:
      API: "http://hs_tools:23280"
      PORT: 8000
      CALLAPI: "http://rollcall_api:8080"
      UPLOADAPI: "HTTP://file_resource_api:8080"
      PROXY_URL: "huansi_nginx:80"
    container_name: webboard_web
    networks:
      - huansi_nets

  # {"app_code":"FileResource","id":"94","app_name":"文件服务APP","api_port":23274,"api_version":"1.2"}
  file_resource_api:
    image: ${HUANSI_REGISTRY_URL}/huansi/file_resource_api:1.2
    restart: always
    volumes:
      - "/data/file_resouce/file:/huansi_app/static_file/file"
    ports:
      - "23274:8080"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      FILE_EXTENSION: "jpg|jpeg|png|gif|mp4|apk|mp3|xls|xlsx|doc|docx"
      PROXY_URL: "huansi_nginx"
    container_name: file_resource_api
    expose:
      - "8080"
    networks:
      - huansi_nets
      
  # hs_gql
  # {"app_code":"GQL","id":"141","app_name":"HsGQL","api_port":23387,"web_version":"1.0"}
  hs_gql:
    image: ${HUANSI_REGISTRY_URL}/huansi/hs_gql:1.0
    restart: always
    volumes:
      - "/data/hs_gql/static_file/log:/huansi_app/static_file/log"
    ports:
      - "23387:8080"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      PROXY_URL: "huansi_nginx:80"
      HSRIGHT_RPC: "huansi_right_api:8120"
    expose:
      - "8080"
    container_name: hs_gql
    networks:
      - huansi_nets
      
  # 公共类库
  # {"app_code":"CommonUtil","id":"148","app_name":"PbCommon 公共类库APP","api_port":23388,"api_version":"1.0"}
  pb_common_util:
    image: ${HUANSI_REGISTRY_URL}/huansi/pb_common_util:1.0
    restart: always
    volumes:
      - "/data/edi_shipment/static_file/log:/huansi_app/static_file/log"
    ports:
      - "23388:8080"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}" 
      PROXY_URL: "huansi_nginx"
      RPC_PROXY_URL: "huansi_nginx:81"
    expose:
      - "8080"
    container_name: pb_common_util
    networks:
      - huansi_nets

  # 车间生产工位机 android# {"app_code":"mes_pt","id":"93","app_name":"车间生产工位机","web_version":"6","web_publish_version":"2020.03.27.1548","dev_language":"android"}
  mes_pt:
    image: ${HUANSI_REGISTRY_URL}/huansi/mes_pt:6
    restart: 'on-failure'
    volumes:
      - "/data/edi_shipment/static_file/log:/huansi_app/static_file/log"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      PROXY_URL: "huansi_nginx"
    container_name: mes_pt
    networks:
      - huansi_nets

  # 服装成衣质检2 android
  # {"app_code":"inspc","id":"172","app_name":"服装成衣质检","web_version":"2","web_publish_version":"2020.03.27.1827","dev_language":"android"}
  inspc:
    image: ${HUANSI_REGISTRY_URL}/huansi/inspc:2
    restart: 'on-failure'
    volumes:
      - "/data/edi_shipment/static_file/log:/huansi_app/static_file/log"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      PROXY_URL: "huansi_nginx"
    container_name: inspc
    networks:
      - huansi_nets

  # nginx 端口:59168
  # {"app_code":"nginx","id":"999","app_name":"Nginx","api_port":59168,"api_port2":59169,"api_version":"1.0"}
  huansi_nginx:
    image: 47.110.145.204:8084/huansi/nginx:1.0
    restart: always
    volumes:
      - "/data/nginx/conf/:/etc/nginx/conf.d/"
      - "/data/nginx/logs:/var/log/nginx/"
      - "/data/file_resouce:/data/file_resouce"
    ports:
      - "59168:80"
      - "59169:81"
    expose:
      - "80"
      - "81"
    container_name: huansi_nginx
    networks:
      - huansi_nets
      
  # 环思浏览器 android
  # {"app_code":"webbrowes","id":"39","app_name":"环思浏览器","web_version":"2","web_publish_version":"","dev_language":"android"}
  webbrowes:
    image: ${HUANSI_REGISTRY_URL}/huansi/webbrowes:2
    restart: 'on-failure'
    volumes:
      - "/data/edi_shipment/static_file/log:/huansi_app/static_file/log"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      PROXY_URL: "huansi_nginx"
    container_name: webbrowes
    networks:
      - huansi_nets
      
  # 警官监管PAD android
  # {"app_code":"padmc","id":"153","app_name":"警官监管PAD","web_version":"5","web_publish_version":"","dev_language":"android"}
  padmc:
    image: ${HUANSI_REGISTRY_URL}/huansi/padmc:5
    restart: 'on-failure'
    volumes:
      - "/data/edi_shipment/static_file/log:/huansi_app/static_file/log"
    environment:
      DB_USER: "${HSDB_USER}"
      DB_PASSWORD: "${HSDB_PASSWORD}"
      DB_HOST: "${HSDB_HOST}"
      DB_PORT: "${HSDB_PORT}"
      DB_NAME: "${MESDB_NAME}"
      PROXY_URL: "huansi_nginx"
    container_name: padmc
    networks:
      - huansi_nets
      
networks:
  huansi_nets:
    driver: bridge'''


image_info_str = '''IMAGE ID            REPOSITORY                                     TAG
f13647e085c3        47.110.145.204:8084/huansi/hs_tools            1.2
d85a74aa5cf5        47.110.145.204:8084/huansi/padmc               5
fb9e6a522b1f        47.110.145.204:8084/huansi/webboard_web        1.3
b256b201b89b        47.110.145.204:8084/huansi/hs_right_api        1.2
7e96c8152933        47.110.145.204:8084/huansi/board_bi_web        1.4
69a751be1071        47.110.145.204:8084/huansi/hs_tools            1.1
cd645f5a4769        portainer/portainer                            latest
44897cd9590d        47.110.145.204:8084/huansi/file_resource_api   1.2
61bd782126bd        47.110.145.204:8084/huansi/rollcall_api        1.1
6d7625bb09aa        47.110.145.204:8084/huansi/inspc               2
c496caa8d803        47.110.145.204:8084/huansi/mes_pt              5
28b0fc98fc20        47.110.145.204:8084/huansi/hs_right_web        1.2
9596ba619642        47.110.145.204:8084/huansi/pb_common_util      1.0
296552b6b1a7        47.110.145.204:8084/huansi/webbrowes           2
87173d516cf5        47.110.145.204:8084/huansi/hs_gql              1.0
f949e7d76d63        47.110.145.204:8084/huansi/nginx               1.0
b1742831a1ea        47.110.145.204:8084/huansi/mq                  latest
0f55cf3661e9        47.110.145.204:8084/huansi/redis               latest'''

local_image_info = '''IMAGE ID            REPOSITORY                                     TAG
b19b84681a4c        gitlab/gitlab-runner-helper                    x86_64-6fbc7474
f13647e085c3        47.110.145.204:8084/huansi/hs_tools            1.2
d85a74aa5cf5        47.110.145.204:8084/huansi/padmc               5
fb9e6a522b1f        47.110.145.204:8084/huansi/webboard_web        1.3
b256b201b89b        47.110.145.204:8084/huansi/hs_right_api        1.2
3f09a0b137c1        47.110.145.204:8084/huansi/install_web         2.0
54ba330cd824        gitlab/gitlab-runner                           latest
9567f555bb1e        47.110.145.204:8084/huansi/install_api         2.0
7e96c8152933        47.110.145.204:8084/huansi/board_bi_web        1.4
69a751be1071        47.110.145.204:8084/huansi/hs_tools            1.1
cd645f5a4769        portainer/portainer                            latest
44897cd9590d        47.110.145.204:8084/huansi/file_resource_api   1.2
61bd782126bd        47.110.145.204:8084/huansi/rollcall_api        1.1
6d7625bb09aa        47.110.145.204:8084/huansi/inspc               2
c496caa8d803        47.110.145.204:8084/huansi/mes_pt              5
28b0fc98fc20        47.110.145.204:8084/huansi/hs_right_web        1.2
9596ba619642        47.110.145.204:8084/huansi/pb_common_util      1.0
b700a4b0c0aa        chaozi/docker-compose                          latest
296552b6b1a7        47.110.145.204:8084/huansi/webbrowes           2
87173d516cf5        47.110.145.204:8084/huansi/hs_gql              1.0
f949e7d76d63        47.110.145.204:8084/huansi/nginx               1.0
b1742831a1ea        47.110.145.204:8084/huansi/mq                  latest
0f55cf3661e9        47.110.145.204:8084/huansi/redis               latest
fce289e99eb9        hello-world                                    latest'''

import re


def convert_image_info_str_to_list(image_info_str):
    '''
    将命令docker images --format "table {{.ID}}\t{{.Repository}}\t{{.Tag}}"的结果转换为数组
    :param image_info_str:
    :return:
    '''
    image_info_str = image_info_str.replace('\r', '')
    server_image_str_list = image_info_str.split('\n')[1:]
    image_info_list = []
    for server_image_str in server_image_str_list:
        if not server_image_str:
            continue
        _l = re.findall('(\S+) +(\S+) +(\S+)', server_image_str)[0]
        if _l[2] == '<none>':
            continue

        image_info = {}
        image_info['id'] = _l[0]
        image_info['name'] = _l[1]
        image_info['tag'] = _l[2]
        image_info_list.append(image_info)

    return image_info_list



if __name__ == '__main__':
    server_image_list = convert_image_info_str_to_list(image_info_str)

    # 本地机制
    # 取compose中的所有app

    deploy_image_list = []
    image_info_list = re.findall(r' (.*):\r*\n *image: (.*)\n', compose_content)
    for image_info in image_info_list:
        code = image_info[0]
        image = image_info[1]
        # 要考虑直接输入ip的情况
        if '47.110.145.204:8084' in image:
            image = image.replace('47.110.145.204:8084', '${HUANSI_REGISTRY_URL}')

        _l = image.split(':')
        if len(_l) == 1:
            tag = 'latest'
        else:
            tag = _l[1]
        # 划分app镜像名和版本号
        _image_info = {}
        _image_info['name'] = _l[0].replace('${HUANSI_REGISTRY_URL}', '47.110.145.204:8084')
        _image_info['tag'] = tag
        _image_info['code'] = code
        deploy_image_list.append(_image_info)
    # 本地镜像获取
    local_app_list = convert_image_info_str_to_list(local_image_info)
    # 根据镜像名和版本号过滤本地镜像
    filter_app_list = []
    for local_app in local_app_list:
        filter_app = {}
        app_id = local_app['id']
        app_name = local_app['name']
        app_tag = local_app['tag']
        for deploy_image in deploy_image_list:
            image_name = deploy_image['name']
            image_tag = deploy_image['tag']
            code = deploy_image['code']

            if app_tag == image_tag and app_name == image_name:
                filter_app['tag'] = app_tag
                filter_app['id'] = app_id
                filter_app['name'] = app_name
                filter_app['code'] = code
                break
        if filter_app:
            filter_app_list.append(filter_app)
    print(filter_app_list)
    # 在和服务器的做对比
    result_list = []
    for server_image in server_image_list:
        result_dict = {}
        server_image_id = server_image['id']
        server_image_name = server_image['name']
        server_image_tag = server_image['tag']
        for filter_app in filter_app_list:
            filter_app_id = filter_app['id']
            filter_app_name = filter_app['name']
            filter_app_tag = filter_app['tag']
            filter_app_code = filter_app['code']
            if server_image_name == filter_app_name:
                result_dict['server_id'] = server_image_id
                result_dict['server_name'] = server_image_name
                result_dict['server_tag'] = server_image_tag
                result_dict['local_id'] = filter_app_id
                result_dict['local_name'] = filter_app_name
                result_dict['local_tag'] = filter_app_tag
                result_dict['code'] = filter_app_code
                break
        else:
            result_dict['server_id'] = server_image_id
            result_dict['server_name'] = server_image_name
            result_dict['server_tag'] = server_image_tag
            result_dict['code'] = ''
            result_dict['local_id'] = ''
            result_dict['local_name'] = ''
            result_dict['local_tag'] = ''

        # 只赋值code有值的数据
        if result_dict.get('code'):
            result_list.append(result_dict)

    for filter_app in filter_app_list:
        result_dict = {}
        filter_app_id = filter_app['id']
        filter_app_name = filter_app['name']
        filter_app_tag = filter_app['tag']
        filter_app_code = filter_app['code']
        for server_image in server_image_list:
            server_image_name = server_image['name']

            if server_image_name == filter_app_name:
                break
        else:
            result_dict['server_id'] = ''
            result_dict['server_name'] = ''
            result_dict['server_tag'] = ''
            result_dict['local_id'] = filter_app_id
            result_dict['local_name'] = filter_app_name
            result_dict['local_tag'] = filter_app_tag
            result_dict['code'] = filter_app_code

        # 只赋值code有值的数据
        if result_dict and result_dict.get('code'):
            result_list.append(result_dict)

    print(result_list)