# -*- coding:utf-8 -*-
import json
import os
import unittest

from flask_app import global_app
from static_file import temp_file_dir

session_info_path = os.path.join(temp_file_dir, 'session.info')


class TestAuthorization(unittest.TestCase):
    def setUp(self):
        self.client = global_app.test_client()

    def test_get_session_info(self):
        # 删除文件
        if os.path.exists(session_info_path):
            os.remove(session_info_path)

        res = self.client.get('/authorization/')
        self.assertEqual(res.status_code, 200)

        self.assertFalse(res.json)

        # 缓存文件不存在
        self.assertFalse(os.path.exists(session_info_path))

    def test_set_session_info(self):
        headers = {
            'Content-Type': "application/json",
        }
        # 正常新增
        json_data = {"user_name": "123", "password": "321"}
        res = self.client.post('/authorization/', headers=headers, json=json_data)
        self.assertEqual(res.status_code, 200)

        # 缓存文件存在
        self.assertTrue(os.path.exists(session_info_path))

        # 判断是否正常的文件
        with open(session_info_path, 'r') as f:
            session_info = f.read()
        session_info_dict = json.loads(session_info)
        self.assertEqual(session_info_dict, json_data)

    def test_login(self):
        self.test_set_session_info()

        headers = {
            'Content-Type': "application/json",
        }
        # 正常新增
        json_data = {"user_name": "124", "password": "321"}
        res = self.client.post('/authorization/login/', headers=headers, json=json_data)
        self.assertEqual(res.status_code, 501)
        self.assertEqual(res.json['error_title'], '账号或密码错误')

        json_data = {"user_name": "123", "password": "321"}
        res = self.client.post('/authorization/login/', headers=headers, json=json_data)
        self.assertEqual(res.status_code, 200)
        self.assertEqual(res.json['message'], '登录成功')
