# -*- coding:utf-8 -*-
import json
import os

from huansi_utils.exception.exception import HSException
from huansi_utils.server.service_uc import HSBaseUCService

from static_file import temp_file_dir

session_info_path = os.path.join(temp_file_dir, 'session.info')


class AuthorizationService(HSBaseUCService):
    def get_session_info(self):
        '''
        查询是否有session信息
        :return:
        '''
        if os.path.exists(session_info_path):
            return True
        else:
            return False

    def set_esssion_info(self, json_data):
        '''
        设置session信息
        :param json_data:
        :return:
        '''
        user_name = json_data.get('user_name')
        password = json_data.get('password')
        session_info = json.dumps({'user_name': user_name, 'password': password})
        with open(session_info_path, 'w') as f:
            f.write(session_info)

    def login(self, json_data):
        '''
        登录
        :param json_data:
        :return:
        '''
        if not self.get_session_info():
            raise HSException('账号或密码错误')

        with open(session_info_path, 'r') as f:
            session_info = f.read()
        session_info_dict = json.loads(session_info)

        if session_info_dict.get('user_name') == json_data.get('user_name') and \
                session_info_dict.get('password') == json_data.get('password'):
            return {'message': '登录成功'}
        else:
            raise HSException('账号或密码错误')
