# -*- coding:utf-8 -*-
import os

from huansi_utils.db.db import new_id
from huansi_utils.exception.exception import HSException

from app.utils.common_tools import CommonTools
from app.utils.db_tools import db_driver
from static_file import profile_dir


class ConnectionService():
    def get_project_info(self, project_no, sync_file=False):
        '''
        获取项目信息
        :return:
        '''
        with db_driver as session:
            project_info = session.retrive_sql(f"select * from project_info where project_no = '{project_no}'")

        # 每次获取都是自动切换配置
        if project_info and sync_file:
            self.generate_huansi_profiled(project_info)

        return project_info

    def set_project_info(self, json_data):
        '''
        设置项目信息
        :param json:{"project_no": "j1kq", "db_ip": "47.97.206.38", "db_port": "9610", "db_user": "000",
                     "db_password": "000", "mes_db_name": "HSGmtMes", "tiip_db_name": "HSTIIP"}
        :return:
        '''
        CommonTools.validate_dict_value_all_not_none(json_data)

        id = json_data.get('id')
        project_no = json_data.get('project_no').strip()
        db_ip = json_data.get('db_ip')
        db_port = json_data.get('db_port')
        db_user = json_data.get('db_user').strip()
        db_password = json_data.get('db_password').strip()
        mes_db_name = json_data.get('mes_db_name').strip()
        host_ip = json_data.get('host_ip')

        # 验证数据库连接是否正确
        if not CommonTools().test_db_connection(db_ip, db_port, db_user, db_password, mes_db_name):
            raise HSException('您填写的数据库信息未能连接上数据库，请检查')

        with db_driver as session:
            if id:

                validate_sql = f"select * from project_info where project_no='{project_no}' and id<>'{id}' "
                validate_data = session.retrive_sql(validate_sql)
                if validate_data:
                    raise HSException(f'{project_no}已经存在')

                update_sql = f'''update project_info
set project_no='{project_no}',db_ip='{db_ip}',db_port='{db_port}',db_user='{db_user}'
,db_password='{db_password}',mes_db_name='{mes_db_name}',host_ip='{host_ip}'
where id='{id}' '''
                session.exec_sql(update_sql, json_data)

            else:
                project_no_list = self.get_project_no_list()
                if project_no in project_no_list:
                    raise HSException(f"{project_no}已经存在")

                id = new_id()
                json_data['id'] = id
                insert_sql = f'''insert into project_info
(id,project_no,db_ip,db_port,db_user
,db_password,mes_db_name,tiip_db_name,host_ip)
values
({id},'{project_no}','{db_ip}','{db_port}','{db_user}'
,'{db_password}','{mes_db_name}','','{host_ip}')'''
                session.exec_sql(insert_sql, json_data)

            data = session.retrive_sql(f"select * from project_info where id={id}")

            if not data:
                raise HSException('保存失败')

            self.generate_huansi_profiled(data)

            return {'message': "保存成功"}

    def generate_huansi_profiled(self, data):
        import os
        from static_file import profile_dir
        project_info_path = os.path.join(profile_dir, 'huansi.sh')
        # 写入
        with open(project_info_path, "w") as f:
            for k, v in data.items():
                if isinstance(v, str):
                    v = v.strip()
                k = self.math_name(k)
                if k in ['ID', 'CREATE_TIME']:
                    continue
                f.writelines("export {}={}\n".format(k, v))
                # mes的数据库写两次，兼容之前的
                if k == 'HSDB_NAME':
                    f.writelines("export {}={}\n".format('MESDB_NAME', v))

    def math_name(self, k):
        '''
        匹配名称
        :param k:
        :return:
        '''
        if k == 'project_no':
            return 'HSCUSCODE'
        if k == 'db_ip':
            return 'HSDB_HOST'
        if k == 'db_port':
            return 'HSDB_PORT'
        if k == 'db_user':
            return 'HSDB_USER'
        if k == 'db_password':
            return 'HSDB_PASSWORD'
        if k == 'mes_db_name':
            return 'HSDB_NAME'
        else:
            return k.upper()

    def test_connection(self, json_data):
        '''
        测试数据库连接
        :param project_no:
        :param db_name:
        :return:
        '''

        CommonTools.validate_dict_value_all_not_none(json_data)

        db_ip = json_data['db_ip']
        db_port = json_data['db_port']
        db_user = json_data['db_user']
        db_password = json_data['db_password']
        test_db_name = json_data['mes_db_name']

        if CommonTools().test_db_connection(db_ip, db_port, db_user, db_password, test_db_name):
            return {'message': '连接成功'}
        else:
            return {'message': '连接失败'}

    def get_remote_server_info(self, project_no, work_shop_no):
        '''
        获取远端服务器信息
        :return:
        '''
        with db_driver as session:
            remote_server_info = session.retrive_sql(
                f"select * from remote_server_info where project_no='{project_no}' and work_shop_no='{work_shop_no}' ")

        return remote_server_info

    def set_remote_server_info(self, json_data):
        '''
        设置远端服务器信息
        :return:
        '''
        CommonTools.validate_dict_value_all_not_none(json_data)

        id = json_data.get('id')
        project_no = json_data.get('project_no')
        work_shop_no = json_data.get('work_shop_no')
        server_ip = json_data.get('server_ip')
        server_ssh_port = json_data.get('server_ssh_port')
        server_user = json_data.get('server_user')
        server_password = json_data.get('server_password')

        if project_no is None or server_ip is None or server_ssh_port is None or \
                server_user is None or server_password is None or work_shop_no is None:
            raise HSException('以上参数全部必填')

        project_no = project_no.strip()
        server_ip = server_ip.strip()
        server_user = server_user.strip()
        server_password = server_password.strip()
        work_shop_no = work_shop_no.strip()

        with db_driver as session:
            if id:
                validate_sql = f"select * from remote_server_info where project_no='{project_no}' and work_shop_no='{work_shop_no}' and id<>'{id}' "
                validate_data = session.retrive_sql(validate_sql)
                if validate_data:
                    raise HSException(f'{project_no}-{work_shop_no}已经存在')

                update_sql = f'''update remote_server_info
set project_no='{project_no}',server_ip='{server_ip}',server_ssh_port='{server_ssh_port}',server_user='{server_user}'
,server_password='{server_password}',work_shop_no='{work_shop_no}'
where id='{id}' '''
                session.exec_sql(update_sql, json_data)

            else:
                project_no_sql = f"select project_no from remote_server_info where project_no='{project_no}' and work_shop_no='{work_shop_no}'"
                project_no_data = session.retrive_sql(project_no_sql)
                if project_no_data:
                    raise HSException(f"{project_no}-{work_shop_no}已经存在")

                id = new_id()
                json_data['id'] = id
                insert_sql = f'''insert into remote_server_info
(id,project_no,server_ip,server_ssh_port,server_user
,server_password,work_shop_no)
values
('{id}','{project_no}','{server_ip}','{server_ssh_port}','{server_user}','{server_password}','{work_shop_no}') '''
                session.exec_sql(insert_sql, json_data)

            return {'message': "保存成功"}

    def set_remote_db_info(self, json_data):
        '''
        设置远程服务器数据库配置
        :param param:
        :return:
        '''
        '''project_no,db_ip,db_port,db_user,db_password,mes_db_name'''

        id = json_data.get('id')
        project_no = json_data.get('project_no')
        work_shop_no = json_data.get('work_shop_no', '').strip()
        db_ip = json_data.get('db_ip')
        db_port = json_data.get('db_port')
        db_user = json_data.get('db_user')
        db_password = json_data.get('db_password')
        mes_db_name = json_data.get('mes_db_name')

        if project_no is None or db_ip is None or db_port is None or \
                db_user is None or db_password is None or mes_db_name is None or not work_shop_no:
            raise HSException('以上参数全部必填')

        project_no = project_no.strip()
        work_shop_no = work_shop_no.strip()
        db_ip = db_ip.strip()
        db_user = db_user.strip()
        db_password = db_password.strip()
        mes_db_name = mes_db_name.strip()

        with db_driver as session:
            if id:
                validate_sql = f"select * from remote_server_db_info where project_no='{project_no}' and work_shop_no='{work_shop_no}' and id<>'{id}' "
                validate_data = session.retrive_sql(validate_sql)
                if validate_data:
                    raise HSException(f'{project_no}-{work_shop_no}已经存在')

                # update
                sql = f'''update remote_server_db_info
set project_no='{project_no}',db_ip='{db_ip}',db_port='{db_port}'
,db_user='{db_user}',db_password='{db_password}',mes_db_name='{mes_db_name}'
,work_shop_no='{work_shop_no}'
where id={id}'''
            else:
                project_no_sql = f"select project_no from remote_server_db_info where project_no='{project_no}' and work_shop_no='{work_shop_no}'"
                project_no_data = session.retrive_sql(project_no_sql)
                if project_no_data:
                    raise HSException(f"{project_no}-{work_shop_no}已经存在")
                id = new_id()
                # insert
                sql = f'''insert into remote_server_db_info
(id,project_no,db_ip,db_port,db_user,db_password,mes_db_name,work_shop_no)
values 
('{id}','{project_no}','{db_ip}','{db_port}','{db_user}','{db_password}','{mes_db_name}','{work_shop_no}')'''

            session.exec_sql(sql)

        self.generate_huansi_server_profiled(json_data)

        return {'message': "保存成功"}

    def generate_huansi_server_profiled(self, json_data):
        '''
        生成服务器配置文件
        :param json_data:
        :return:
        '''
        remote_db_info_path = os.path.join(profile_dir, 'huansi_server.sh')
        # 写入
        with open(remote_db_info_path, "w") as f:
            for k, v in json_data.items():
                if isinstance(v, str):
                    v = v.strip()
                k = self.math_name(k)
                if k in ['ID', 'CREATE_TIME']:
                    continue
                f.writelines("export {}={}\n".format(k, v))
                # mes的数据库写两次，兼容之前的
                if k == 'HSDB_NAME':
                    f.writelines("export {}={}\n".format('MESDB_NAME', v))

    def get_remote_db_info(self, project_no, work_shop_no, sync_file=False):
        '''
        获取远程服务器数据库配置
        :return:
        '''
        with db_driver as session:
            get_remote_db_sql = f'''select * from remote_server_db_info where project_no='{project_no}' and work_shop_no='{work_shop_no}' '''
            remote_db_info = session.retrive_sql(get_remote_db_sql)

        if remote_db_info and sync_file:
            self.generate_huansi_server_profiled(remote_db_info)

        return remote_db_info

    def get_project_no_list(self, project_no=''):
        '''
        获取客户代码列表
        :param project_no: 客户代码，用于搜索
        :return:
        '''
        if project_no:
            where = f"where project_no like '%{project_no}%'"
        else:
            where = ''

        with db_driver as session:
            get_project_no_list_sql = f'''select project_no
from project_info
{where}'''
            project_no_list = session.query_sql(get_project_no_list_sql)

        return project_no_list

    def get_remote_server_project_no_list(self, project_no=''):
        '''
        获取远程服务器连接配置的项目编号列表
        :param project_no: 客户代码，用于搜索
        :return:
        '''
        if project_no:
            where = f"where project_no like '%{project_no}%'"
        else:
            where = ''

        with db_driver as session:
            get_remote_server_project_no_list_sql = f'''select project_no
from remote_server_info
{where}'''
            project_no_list = session.query_sql(get_remote_server_project_no_list_sql)

        return project_no_list

    def sync_remote_db_info(self):
        '''
        兼容之前的修改
        :return:
        '''
        import os
        from static_file import profile_dir

        remote_db_info_path = os.path.join(profile_dir, 'huansi_server.sh')

        if not os.path.exists(remote_db_info_path):
            return

        with open(remote_db_info_path, "r") as f:
            data = f.read()

        data = data.replace('export ', '')

        data_item_list = data.split('\n')

        data_dict = {}
        for data_item in data_item_list:
            _l = data_item.split('=')
            if _l[0] == 'HSCUSCODE':
                data_dict['project_no'] = _l[1]
            if _l[0] == 'WORK_SHOP_NO':
                data_dict['work_shop_no'] = _l[1]
            if _l[0] == 'HSDB_HOST':
                data_dict['db_ip'] = _l[1]
            if _l[0] == 'HSDB_PORT':
                data_dict['db_port'] = _l[1]
            if _l[0] == 'HSDB_USER':
                data_dict['db_user'] = _l[1]
            if _l[0] == 'HSDB_PASSWORD':
                data_dict['db_password'] = _l[1]
            if _l[0] == 'HSDB_NAME':
                data_dict['mes_db_name'] = _l[1]
            if _l[0] == 'TIIP_DB_NAME':
                data_dict['tiip_db_name'] = _l[1]

        project_no = data_dict['project_no']
        work_shop_no = data_dict.get('work_shop_no')
        if not work_shop_no:
            data_dict['work_shop_no'] = 'unknown'

        with db_driver as session:
            remote_db_sql = f"""select project_no from remote_server_db_info 
where project_no='{project_no}' and work_shop_no='{work_shop_no}' """
            remote_db_data = session.retrive_sql(remote_db_sql)

            if not remote_db_data:
                self.set_remote_db_info(data_dict)

    def get_work_shop_list(self, project_no):
        '''
        获取车间列表
        :param project_no:
        :return:
        '''
        sql = f'''select work_shop_no
from remote_server_db_info
where project_no='{project_no}' '''
        with db_driver as session:
            return session.query_sql(sql)

    def get_project_info_list(self):
        '''
        获取项目信息列表
        :return:
        '''
        sql = '''select * from project_info'''
        with db_driver as session:
            return session.query_sql(sql)

    def delete_project_info_list(self, id_list):
        '''
        删除项目信息列表
        :param id_list:
        :return:
        '''
        id_str = ','.join(id_list)
        sql = f'''delete from project_info
where id in ({id_str})'''

        with db_driver as session:
            session.exec_sql(sql)

    def get_remote_db_list(self):
        '''
        获取远程服务器DB列表
        :return:
        '''
        sql = '''select * from remote_server_db_info'''
        with db_driver as session:
            return session.query_sql(sql)

    def delete_remote_db_list(self, id_list):
        '''
        删除远程服务器DB列表
        :param id_list:
        :return:
        '''
        id_str = ','.join(id_list)
        sql = f'''delete from remote_server_db_info
where id in ({id_str})'''

        with db_driver as session:
            session.exec_sql(sql)
