# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.info.info_service import InfoService


@api('info')
class InfoAPI(ApiController):
    @api('app_list')
    def get_app_list(self):
        '''
        获取app_list
        :return:
        '''
        return InfoService().get_app_list()

    @api('app_upgrade')
    def post_set_app_upgrade_info(self):
        '''
        配置app升级信息
        :return:
        '''
        return InfoService().set_upgrade_info(request.json)

    @api('upgrade_log')
    def get_upgrade_log(self):
        '''
        获取app升级日志列表
        :return:
        '''
        args = request.args
        return InfoService().get_upgrade_log(args)

    @api('nginx_conf')
    def post_nginx(self):
        '''
        同步nginx配置文件
        :return:
        '''
        json_data = request.get_json()
        nginx_conf = json_data.get('data')
        file_name = json_data.get('file_name')
        return InfoService().sync_nginx(file_name, nginx_conf)

    @api('upgrade_log_dtl/<int:log_id>')
    def get_upgrade_log_dtl(self, log_id):
        '''
        获取app单次升级日志明细
        :param log_id:
        :return:
        '''
        args = request.args
        return InfoService().get_upgrade_log_dtl(log_id, args)

    @api('logs')
    def get_install_logs_info(self):
        '''
        获取日志信息
        :return:
        '''
        args = request.args
        return InfoService().get_install_logs(args)
