# -*- coding:utf-8 -*-
import os
import threading
import time
from threading import Thread

from app.utils.thread_tools import ThreadTools
from huansi_utils.app.apploader import logger
from huansi_utils.exception.exception import HSException
from huansi_utils.server.service_uc import HSBaseUCService

from app.conncetion.conncetion_service import ConnectionService
from app.utils.ssh_tools import SSHConnect
from static_file import system_file_dir


class InstallService(HSBaseUCService):

    def install_runner(self, project_no):
        '''
        安装runner
        :return:
        '''

        # 每次只能有一个推送进程
        for thread_item in threading.enumerate():
            if not isinstance(thread_item, threading.Thread):
                continue

            if thread_item.name == 'install_runner':
                logger.info('发现之前一个线程正在处理，杀死它，重新启动')
                # 停止线程
                ThreadTools().stop_thread(thread_item)

        t = Thread(target=self._install_runner, args=(project_no,), name='install_runner')
        t.start()

        return {"message": "开始安装runner"}

    def _install_runner(self, project_no):
        logger.info('开启安装runner')
        from flask_app import global_app
        with global_app.app_context():
            from flask import g
            g.user = {}
            g.language = 'cn'
            self.install_huansi_runner(project_no)

    def install_huansi_runner(self, HSCUSCODE):
        '''
        安装
        :param HSCUSCODE:
        :return:
        '''
        self.delete_setting_file()
        s1 = os.system("docker run --rm -i -v /etc/gitlab-runner:/etc/gitlab-runner gitlab/gitlab-runner register \
                           -n -u http://47.110.145.204:8085/ -r WwpzH4qk19KjvAjEwoTz --executor docker --docker-image docker \
                           --description huansi.{hscode} \
                           --tag-list huansi.{hscode}".format(hscode=HSCUSCODE))
        if s1 != 0:
            logger.info('runner安装失败')
            raise HSException('gitlab-runner安装失败')
        self._edit_runner_setting()
        self._remove_old_runner_container()
        self.start_runner()
        logger.info('runner安装成功')

    def _edit_runner_setting(self):
        logger.info('修改配置文件')
        os.system("chmod 777 /etc/gitlab-runner/config.toml")
        with open('/etc/gitlab-runner/config.toml', 'r') as f:
            s = f.read()
            a = s.replace('volumes = ["/cache"]',
                          'volumes = ["/var/run/docker.sock:/var/run/docker.sock","/etc/profile.d/huansi.sh:/etc/profile.d/huansi.sh" ,"/cache","/huansi/gitlab-runner/builds:/builds/hs","/data/nginx/conf/:/data/nginx/conf/"]')
        with open('/etc/gitlab-runner/config.toml', 'w') as f:
            f.write(a)
        logger.info('修改配置文件成功')

    def _remove_old_runner_container(self):
        '''
        移除旧runner容器，主要作用于第二次第三次的重复安装
        :return:
        '''
        logger.info('删除旧容器')
        os.system("docker stop gitlab-runner && docker rm gitlab-runner")
        logger.info('删除旧容器成功')

    def start_runner(self):
        logger.info('重新启动runner')
        s = os.system("docker run -d --name gitlab-runner --restart always \
                       -v /etc/gitlab-runner:/etc/gitlab-runner \
                       -v /var/run/docker.sock:/var/run/docker.sock \
                       -v /etc/profile.d/huansi.sh:/etc/profile.d/huansi.sh \
                       gitlab/gitlab-runner:latest")

        if s != 0:
            logger.info('runner安装失败')
            raise HSException('启动runner失败')
        logger.info('重新启动runner成功')

    def delete_setting_file(self):
        logger.info('删除配置文件')
        os.system('rm -f /etc/gitlab-runner/config.toml')
        logger.info('删除配置文件成功')

    def install_remote_service_docker(self, project_no, work_shop_no):
        '''
        安装远端服务器的docker
        :return:
        '''
        t = Thread(target=self._install_remote_service_docker, args=(project_no, work_shop_no))
        t.start()

        return {"message": "开始安装docker"}

    def _install_remote_service_docker(self, project_no, work_shop_no):
        logger.info('开启安装docker')
        logger.info('期间需要一段时间，请耐心等待')
        from flask_app import global_app
        with global_app.app_context():
            from flask import g
            g.user = {}
            g.language = 'cn'

            remote_server_info = ConnectionService().get_remote_server_info(project_no, work_shop_no)
            if not remote_server_info:
                logger.info('docker安装失败')
                raise HSException('远端服务器信息未查到，请先配置')

            ssh_conenct = SSHConnect(host_ip=remote_server_info['server_ip'],
                                     host_port=remote_server_info['server_ssh_port'],
                                     user_name=remote_server_info['server_user'],
                                     password=remote_server_info['server_password'])

            with ssh_conenct as ssh:
                # 验证远端服务器有没有按照docker
                self.validate_remote_server_install_docker(ssh)
                # 先上传必要的文件
                logger.info('上传文件docker-19.03.4.tgz')
                ssh.upload('/data/docker-19.03.4.tgz', '/docker-19.03.4.tgz')
                logger.info('上传文件docker-compose-Linux-x86_64')
                ssh.upload('/data/docker-compose-Linux-x86_64', '/docker-compose-Linux-x86_64')
                logger.info('上传文件install_docker.py')
                ssh.upload('/data/install_docker.py', '/install_docker.py')
                # 执行命令
                logger.info('执行安装命令')
                out, err = ssh.exec_command('cd / && python install_docker.py')
                logger.info(f'执行安装命令信息:{out},其他信息:{err}')
                # logger.info('执行重启命令')
                # out2, err2 = ssh.exec_command('reboot')
                # logger.info(f'执行重启命令信息:{out2},错误信息:{err2}')
                # logger.info(f'执行成功，静等服务器重启。。。')
                logger.info('******************************************************')
                logger.info('*********需要在服务器上手工执行reboot重启服务器************')
                logger.info('*********如果有疑问，请联系开发人员***********************')
                logger.info('******************************************************')
                logger.info('docker安装成功')

    def validate_remote_server_install_docker(self, ssh):
        '''
        验证远端服务器是否安装docker
        :param ssh:
        :return:
        '''
        out, err = ssh.exec_command('docker -v')

        if 'Docker version' in out or 'Docker version' in err:
            logger.info('docker安装失败')
            raise HSException('远端服务器已经安装docker，不需要重新安装')
