# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.upgrade.upgrade_service import UpgradeService


@api('upgrade')
class UpgradeAPI(ApiController):
    '''
    1、回滚升级
    2、远程升级
    3、导出安装包
    4、导入安装包升级(不紧急)
    '''

    @api('apply/<string:project_no>')
    def get_apply_db_setting(self, project_no):
        '''
        应用数据库配置
        :return:
        '''
        return UpgradeService().apply_db_setting(project_no)

    @api('remote/server_db/<string:project_no>/<string:work_shop_no>')
    def get_upload_remote_server_db(self, project_no, work_shop_no):
        '''
        上传远程服务器数据库配置文件
        :param project_no:
        :return:
        '''
        return UpgradeService().upload_remote_server_db(project_no, work_shop_no)

    @api('rollback/<string:project_no>/<int:log_id>')
    def get_rollback_upgrade(self, project_no, log_id):
        '''
        回滚升级
        :return:
        '''
        return UpgradeService().rollback_upgrade(project_no, log_id)

    @api('remote/<string:project_no>/<string:work_shop_no>')
    def post_remote_upgrade(self, project_no, work_shop_no):
        '''
        远程升级
        :return:
        '''
        json_data = request.json
        code = json_data.get('code_list')
        return UpgradeService().remote_upgrade(project_no, work_shop_no, code)

    @api('package_images/<int:log_id>')
    def get_package_images(self, log_id):
        '''
        导出镜像
        :param log_id:
        :return:
        '''
        return UpgradeService().package_images(log_id)

    @api('compare_image_info/<string:project_no>/<string:work_shop_no>')
    def get_compare_image_info(self, project_no, work_shop_no):
        '''
        获取服务器和本地要推送的镜像对比
        :param project_no:
        :return:
        '''
        return UpgradeService().get_compare_image_info(project_no, work_shop_no)
