# -*- coding:utf-8 -*-


import paramiko, getpass  # getpass是隐藏密码
from paramiko import AuthenticationException


class SSHConnect():
    def __init__(self, host_ip, host_port, user_name, password):
        self.host_ip = host_ip
        self.host_port = host_port
        self.user_name = user_name
        self.password = password

    def conncet(self):
        try:
            # SSH远程连接
            self.ssh = paramiko.SSHClient()  # 创建sshclient
            self.ssh.set_missing_host_key_policy(
                paramiko.AutoAddPolicy())  # 指定当对方主机没有本机公钥的情况时应该怎么办，AutoAddPolicy表示自动在对方主机保存下本机的秘钥
            self.ssh.connect(self.host_ip, self.host_port, self.user_name, self.password)
        except AuthenticationException:
            raise RuntimeError('登录信息不正确，请检查')
        except Exception:
            raise RuntimeError(f'{self.host_ip}连不上，请检查')

    def __enter__(self):
        self.conncet()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.ssh.close()

    def exec_command(self, command):
        if not self.ssh:
            raise RuntimeError('请先连接')
        # 执行命令并获取执行结果
        stdin, stdout, stderr = self.ssh.exec_command(command)
        out = stdout.read().decode()
        err = stderr.read().decode()

        return out, err

    def upload(self, local_path, target_path):
        """
        本地上传文件到服务器
        :param local_path: 本地文件地址
        :param target_path: 目标文件路径
        """
        sftp = paramiko.SFTPClient.from_transport(self.ssh.get_transport())
        sftp.put(local_path, target_path)

    def download(self, remote_path, local_path):
        """
        服务器下载文件到本地
        :param remote_path: 服务器文件路径
        :param local_path: 本地目标路径
        """
        sftp = paramiko.SFTPClient.from_transport(self.ssh.get_transport())
        sftp.get(remote_path, local_path)
