import os

# api请求加密的密文key
import time

# 签名key
secretKey = '018f162e804f945ee6b23aebfa863639'
# 报表签名key
report_secretKey = 'report028!f162e804f945#eesdkljfdskljfdsXa'
from static_file import base_dir

BASE_DIR = os.path.abspath(os.path.dirname(__file__))


class Config:
    JSON_AS_ASCII = False
    with open(os.path.join(BASE_DIR, "sql_config.txt"), 'r') as f:
        import json
        temp = json.loads(f.read())
        user = os.environ.get('DB_USER') or temp['config']['DB_USER']
        pwd = os.environ.get('DB_PASSWORD') or temp['config']['DB_PASSWORD']
        host = os.environ.get('DB_HOST') or temp['config']['DB_HOST']
        port = int(os.environ.get('DB_PORT', 0)) or temp['config']['DB_PORT']
        db = os.environ.get('DB_NAME') or temp['config']['DB_NAME']
        IP_PORT = temp['config']['IP_PORT'] or 5000
        IP_ADDRESS = temp['config']['IP_ADDRESS']

    data = dict(user=user, pwd=pwd, host=host, port=port, db=db)
    con_str = 'mssql+pymssql://{user}:{pwd}@{host}:{port}/{db}'
    SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or con_str.format(**data)
    # SQLALCHEMY_POOL_SIZE = 5
    SQLALCHEMY_POOL_TIMEOUT = 60
    # SQLALCHEMY_POOL_RECYCLE = -1
    # SQLALCHEMY_MAX_OVERFLOW = 10

    PROJECT_INFO_PATH = os.getenv('PROJECT_INFO_PATH', '/etc/profile.d/huansi.sh')

    # **********全局SQL日志************
    # 全局SQL日志记录
    GLOBAL_SQL_LOG = os.getenv('GLOBAL_SQL_LOG', False)
    # 是否打印全局SQL日志
    GLOBAL_SQL_ECHO = os.getenv('GLOBAL_SQL_ECHO', False)
    # APPCode
    APP_CODE = ''
    # 代理地址
    PROXY_URL = os.getenv('PROXY_URL')
    # rpc代理地址
    RPC_PROXY_URL = os.getenv('RPC_PROXY_URL')
    # rpc服务
    HSRIGHT_RPC = os.getenv('HSRIGHT_RPC')
    # authorize开关
    START_AUTHORIZE = os.getenv('START_AUTHORIZE', False)

    # 日志配置
    syslog_tag = "huansi"
    LOGCONFIG = {
        'version': 1,
        'disable_existing_loggers': False,
        'filters': {},
        'formatters': {
            "defualt": {
                "format": "[%(asctime)s] %(levelname)s - %(message)s"
            },
            "simple": {
                "format": "[%(asctime)s] %(levelname)s - [FileName:%(filename)s] - [FuncName:%(funcName)s] - [LineNo:%(lineno)s} - %(message)s"
            }
        },
        'handlers': {
            'console': {
                '()': 'logging.StreamHandler',
                'formatter': 'defualt'
            },
            'file': {
                '()': 'logging.handlers.RotatingFileHandler',
                'formatter': 'simple',
                'filename': '{}/log/log_{}.txt'.format(base_dir, time.strftime("%Y-%m-%d")),
                'mode': 'a',
                'maxBytes': 50000,  # 5 MB
                'backupCount': 1,
                "encoding": "utf8"
            },
        },
        'loggers': {
            'myapp': {
                'handlers': ['file'],
                'level': 'DEBUG'
            },
        },
        'root': {
            'handlers': ['console'],
            'level': 'DEBUG'
        }
    }
