import logging
import sys

from flask import Flask
from flask_bootstrap import Bootstrap
from flask_logconfig import LogConfig

from huansi_utils.webapi.HSRequest import HSRequest

PYTHON_VERSION = sys.version_info[0]

logger = logging.getLogger(name='myapp')
# 全局数据校验开关
global_validate_switch = True

# 全局token验证开关
# global_verify_token_switch = True
global_verify_token_switch = False


class HSFlask(Flask):
    # 注入自定义的HSRequest类
    request_class = HSRequest


class AppLoaderBase():
    # 暂时不需要单例
    # _instance_lock = threading.Lock()
    #
    # def __new__(cls, *args, **kwargs):
    #     if not hasattr(AppLoaderBase, "_instance"):
    #         with AppLoaderBase._instance_lock:
    #             if not hasattr(AppLoaderBase, "_instance"):
    #                 AppLoaderBase._instance = object.__new__(cls)
    #     return AppLoaderBase._instance

    def __call__(self, *args, **kwargs):
        return self.__app

    @property
    def app(self):
        return self.__app

    def __init__(self):
        self.__app = self.__create_new_app()

    def __create_new_app(self):
        _app = HSFlask(__name__)

        # 禁用信号发送,减少额外内存
        _app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False

        _app.url_map.strict_slashes = True

        self.init(_app)

        LogConfig(_app)
        Bootstrap(_app)

        self.init_db(_app)

        self.register_blueprint(_app)

        self.register_webapi(_app)

        # self.test_connection(_app)

        # 日志处理
        # from huansi_utils.common.cache_log import logThread
        # from huansi_utils.rpc_tools.redis_rpc import handle_rpc_message
        # logThread.start(handle_rpc_message)

        return _app

    def init_db(self, app):
        """
        初始化数据库设置,比如注册orm框架
        :param app: 当前创建的Flask app
        :return:
        """
        pass

    def register_blueprint(self, app):
        """
        注册blueprint
        :param app:当前创建的Flask app
        :return:
        """
        pass

    def register_webapi(self, app):
        """
        注册webapi
        :param app:当前创建的Flask app
        :return:
        """
        pass

    def init(self, app):
        """
        要在初始化时做的其他事情,由子类控制
        :param app:当前创建的Flask app
        :return:
        """
        pass

    def test_connection(self, _app):
        '''
        测试环境变量中的连接是否能正常连接
        :param _app:
        :return:
        '''
        # 部署的时候，发现这么一个问题，huansi_nginx程序部署了，所以连接是通的，但是nginx的反向代理没有部署
        # 老是导致rpc连接超时，暂时只能检测172.17.0.1:8117
        # app_rpc = _app.config.get('RPC_PROXY_URL', None)
        app_rpc = '172.17.0.1:8117'
        # 不存在直接return
        if app_rpc is None:
            return
        # 加上默认端口80
        app_rpc = app_rpc if ':' in app_rpc else app_rpc + ':80'
        ip, port = app_rpc.split(':')
        # 检测app_rpc为正确的地址
        import platform
        sysstr = platform.system()
        # 检测超时的包用到signal，只能在Unix系统上跑，这里加判断防止在Windows机子上开发时报错
        if (sysstr == "Windows"):
            return
        try:
            test_connect_port(ip, port)
            _app.config['HSRPC_STATUS'] = True
            logger.info(f'RPC_PROXY_URL地址{ip}:{port}连上了')
        except Exception:
            _app.config['HSRPC_STATUS'] = False
            logger.info(f'RPC_PROXY_URL地址{ip}:{port}连不上')
        finally:
            logger.info(f"_app.config['HSRPC_STATUS']:{_app.config['HSRPC_STATUS']}")


import timeout_decorator


# 超过两秒，基本上没救了，告辞~~~~
@timeout_decorator.timeout(2)
def test_connect_port(ip, port):
    '''
    检查端口是否开放
    :param ip:
    :param port:
    :return:
    '''
    import socket
    sk = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    if not port:
        port = 80
    try:
        sk.connect((ip, int(port)))
        sk.shutdown(2)
    finally:
        sk.close()
