from celery import Celery,platforms

from celery_config import CELERY_BROKER_URL


def make_celery():
    from flask_app import global_app
    celery = Celery(broker=CELERY_BROKER_URL)
    celery.config_from_object('celery_config')
    TaskBase = celery.Task
    class ContextTask(TaskBase):
        abstract = True
        def __call__(self, *args, **kwargs):
            with global_app.app_context():
                return TaskBase.__call__(self, *args, **kwargs)
    celery.Task = ContextTask
    return celery

celery = make_celery()
platforms.C_FORCE_ROOT = True

