from marshmallow import fields
from huansi_utils.common.schema import HSSchema
import json


# 外部接口调用日志[0]
class PB_InterfaceInvokeLog_schema(HSSchema):
    __tablename__ = 'pbInterfaceInvokeLog'
    __keyfield__ = 'iIden'
    iIden = fields.Integer(allow_none=True)
    sFrom = fields.String(allow_none=True, load_from='from')
    sTo = fields.String(allow_none=True, load_from='to')
    sType = fields.String(allow_none=True, load_from='name')
    sKey = fields.String(allow_none=True, load_from='key')
    sData = fields.Function(allow_none=True, load_from='data', deserialize=lambda x:json.dumps(x))
    tCreateTime = fields.String(load_from='upload_time', function=lambda x:x[:-3])
    iExecResult = fields.Integer(allow_none=True, default=0)
    sResult = fields.String(allow_none=True, load_from='data')
    tEndTime = fields.String(allow_none=True, load_from='time', function=lambda x:x[:-3])

