import os
import time

from flask import current_app
from flask.helpers import find_package


def get_temp_file_name(file_type, temp_file_dir=None):
    # file_int = str(random.randint(1, 100000000))
    file_int = str(int(time.time()))
    if file_type[0:1] != '.':
        file_type = '.' + file_type
    file_name = file_int + file_type
    if not temp_file_dir:
        prefix, package_path = find_package(current_app.import_name)
        temp_file_dir = os.path.join(package_path, 'static_file','temp')
    file_save_name = os.path.join(temp_file_dir, file_name)
    return file_save_name
