# -*- coding:utf-8 -*-
from flask import request
from huansi_utils.webapi import ApiController

from app import api
from app.conncetion.conncetion_service import ConnectionService


@api('connection')
class ConnectionAPI(ApiController):
    @api()
    def get_project_no_list(self):
        '''
        获取客户代码列表
        :return:
        '''
        args = request.args
        project_no = args.get('project_no', '')
        return ConnectionService().get_project_no_list(project_no)

    @api('<string:project_no>')
    def get_project_info(self, project_no):
        '''
        获取项目信息 通过项目编号获取详细信息
        :return:
        '''
        return ConnectionService().get_project_info(project_no, sync_file=True)

    @api()
    def post_set_project_info(self):
        '''
        设置项目信息
        :return:
        '''
        return ConnectionService().set_project_info(request.json)

    @api('test_db_connection')
    def post_test_connection(self):
        '''
        测试项目数据库连接
        :return:
        '''
        return ConnectionService().test_connection(request.json)

    @api('remote_server/<string:project_no>/<string:work_shop_no>')
    def get_remote_server(self, project_no, work_shop_no):
        '''
        获取远程服务器连接
        :return:
        '''
        return ConnectionService().get_remote_server_info(project_no, work_shop_no)

    @api('remote_server')
    def post_set_remote_server_info(self):
        '''
        设置远程服务器连接
        :return:
        '''
        return ConnectionService().set_remote_server_info(request.json)

    @api('work_shop/<string:project_no>')
    def get_work_shop_list(self, project_no):
        '''
        获取车间列表
        :param project_no:
        :return:
        '''
        return ConnectionService().get_work_shop_list(project_no)

    @api('remote_db')
    def post_set_remote_db_info(self):
        '''
        设置远程服务器数据库配置
        :return:
        '''
        return ConnectionService().set_remote_db_info(request.get_json())

    @api('remote_db/<string:project_no>/<string:work_shop_no>')
    def get_remote_db_info(sel, project_no, work_shop_no):
        '''
        获取远程服务器数据库配置
        :return:
        '''
        return ConnectionService().get_remote_db_info(project_no, work_shop_no, sync_file=True)
