import os

import git
from flask import Flask
from huansi_utils.app.apploader import AppLoaderBase
from huansi_utils.db.sqlalchemy import db
from huansi_utils.flask_docs import ApiDoc

from flask_config import Config
from static_file import temp_file_dir

deploy_repo_path = 'ssh://git@47.110.145.204:2222/hs/deploy.git'

git_path = os.path.join(temp_file_dir, 'deploy')


# 初始化git仓库
if not os.path.exists(os.path.join(git_path, '.git')):
    repo = git.Repo.clone_from(url=deploy_repo_path, to_path=git_path)
else:
    repo = git.Repo(git_path)
    repo.git.pull()


class FlashAppLoader(AppLoaderBase):

    def init(self, app: Flask):
        app.config.from_object(Config)
        # 因为之前的基类不规范，到处引用，这样强行将import_name修改成当前文件
        app.import_name = 'flask_app'
        from app.utils.db_tools import db_driver, create_table_sql_list
        with db_driver as session:
            for create_table_sql in create_table_sql_list:
                session.exec_sql(create_table_sql)

        # 兼容之前的db配置
        from app.conncetion.conncetion_service import ConnectionService
        ConnectionService().sync_remote_db_info()

    def register_blueprint(self, app):
        # 新版本api doc
        ApiDoc(app)

    def init_db(self, app):
        db.init_app(app)

    def register_webapi(self, app):
        from app import _webApi
        _webApi.init_app(app)


global_app = FlashAppLoader()()
