import json
from functools import wraps
from flask import request, current_app, g
from huansi_utils.exception.exception import HSException
from huansi_utils.webapi import ApiController


def Authorization(func):
    @wraps(func)
    def decorated_function(*args, **kwargs):
        if getattr(func, '__ignore__', False):
            g.user = {}
            return func(*args, **kwargs)

        # 环境变量控制authorize的启动
        start_authorize = current_app.config.get('START_AUTHORIZE')
        if not start_authorize or str(start_authorize).lower() == 'false':
            g.user = {}
            return func(*args, **kwargs)

        if 'Authorization' in request.headers:
            token = request.headers.get('Authorization')
        else:
            raise HSException('用户没有登录!')
        '''
        token_verify为hsright中验证token的rpc服务名，可以认为是我们进行API访问的url
        message是传递给服务函数的参数，字典格式
        app是开启rpc服务的app
        response取决于服务方如何返回数据
        '''
        response = None
        if response['code'] == 200:
            result = json.loads(response['message'])
            g.user_id = result.get('user_id')
            g.user = result.get('user')
        else:
            raise HSException(response['message'])
        return func(*args, **kwargs)

    # 以下代码演示如何添加一个ApiController的类装饰器,以达到所有方法都应用的目的
    if isinstance(func, type) and issubclass(func, ApiController):
        cls = func
        cls.append_method_decorator(Authorization)
        return cls
    return decorated_function


def UnAuthorization(func):
    '''
    不用验证登录的装饰器
    :param func:
    :return:
    '''
    setattr(func, '__ignore__', True)
    return func
