# -*- coding:utf-8 -*-
from flask import current_app
from hs_rpc import rpc_request_invoke


def send_mq(body, key_route, exchange, expiration=None):
    '''
    mq发送消息---->Tool上的rpc
    :param body: 消息
    :param key_route: 路由key
    :param exchange: 交换机
    :param expiration: 过期时间
    :return:
    '''
    if not current_app.config.get('HSRPC_STATUS', False):
        return None

    response = rpc_request_invoke('send_mq',
                                  message={'body': body
                                      , 'key_route': key_route
                                      , 'exchange': exchange
                                      , 'expiration': expiration},
                                  app_code='Tool')
    return response
