# -*- coding:utf-8 -*-
import json
import unittest

from app.utils.db_tools import db_driver
from flask_app import global_app


class TestGetInfo(unittest.TestCase):
    def setUp(self):
        self.client = global_app.test_client()

    def test_app_list(self):
        # TestDataMaintain().test_get_db_connection()

        res = self.client.get('/info/app_list/')

        self.assertEqual(res.status_code, 200)

        print(json.dumps(res.json, indent=4))

    def test_set_app_list_info(self):
        '''[{app_code,app_name,app_image}]'''

        with db_driver as session:
            session.exec_sql('delete from app_upgrade_log')
            session.exec_sql('delete from app_upgrade_log_dtl')

        headers = {
            'Content-Type': "application/json",
        }
        # 正常新增
        json_data = [
            {"app_code": "rabbitMQ", "app_name": "rabbitMQ", "app_image": "47.110.145.204:8084/huansi/mq:latest"},
            {"app_code": "Redis", "app_name": "Redis", "app_image": "47.110.145.204:8084/huansi/redis:latest"},
            {"app_code": "Tool", "app_name": "tools工具集", "app_image": "47.110.145.204:8084/huansi/hs_tools:1.1"}]

        res = self.client.post('/info/app_upgrade/', headers=headers, json=json_data)
        self.assertEqual(res.status_code, 200)
        self.assertEqual(res.json['message'], '写入成功')

    def test_get_upgrade_log(self):
        res = self.client.get('/info/upgrade_log/')
        self.assertEqual(res.status_code, 200)
        print(res.json)

    def test_get_upgrade_log_dtl(self):
        log_id = 1238385199009665024
        res = self.client.get('/info/upgrade_log_dtl/{}/?per_page=2&page=2'.format(log_id))
        self.assertEqual(res.status_code, 200)
        print(res.json)
