# -*- coding:utf-8 -*-
import os

import timeout_decorator

from huansi_utils.app.apploader import logger
from huansi_utils.exception.exception import HSException


class CommonTools:
    @classmethod
    def validate_dict_value_all_not_none(cls, dict_data: dict, mapping=None):
        '''
        验证字典的值全不为空
        :return:
        '''
        if not isinstance(dict_data, dict):
            raise HSException('dict_data必须为字典类型')

        for key, value in dict_data.items():
            if value is None:
                raise HSException(f"{key}不能为空")

    # 超过四秒，基本上没救了，告辞~~~~
    @timeout_decorator.timeout(4)
    def test_db_connection(cls, ip: int, port: int, user_name: str, password: str, db_name: str):
        '''
        测试数据库连接
        :param ip:
        :param port:
        :param user_name:
        :param password:
        :param db_name:
        :param sql:
        :return:
        '''
        from sqlalchemy import create_engine
        from sqlalchemy.orm import sessionmaker

        con_str = f'mssql+pymssql://{user_name}:{password}@{ip}:{port}/{db_name}'

        engine = create_engine(con_str)

        DBSession = sessionmaker(bind=engine)

        try:
            session = DBSession()

            result = session.execute("select test='huansi'")

            data = result.fetchone()

            if data.test == 'huansi':
                return True
            else:
                return False

        except Exception as e:
            orig = getattr(e, 'orig')
            args = getattr(orig, 'args', ((),))[0]
            error_message = ''
            for e_item in args:
                if isinstance(e_item, bytes):
                    try:
                        e_item = e_item.decode()
                    except:
                        e_item = str(e_item)
                error_message += str(e_item)

            if not error_message:
                error_message = str(e)

            logger.error("数据库连接失败，失败原因：{}".format(error_message))

            return False

    @classmethod
    def validate_runner_is_install(self):
        '''
        验证runner是否成功安装
        :return:
        '''
        runner_file_path = '/etc/gitlab-runner/config.toml'
        if not os.path.exists(runner_file_path):
            raise HSException('没有安装runner')
