import logging
import sys
from huansi_utils.flask_douwa.cache import RedisCache

redis = RedisCache()
logger = logging.getLogger(__name__)


class Douwa(object):
    client_access = list()

    def __init__(self, app=None):
        self.getid = None
        self.kafka_callback = None
        if app is not None:
            self.init_app(app)

    def init_app(self, app):
        host = app.config.get("GENERATORID_IP", None)
        r_host = app.config.get("REDIS_HOST", None)
        r_port = app.config.get("REDIS_PORT", None)
        r_db = app.config.get("REDIS_DB", None)
        r_pwd = app.config.get("REDIS_PWD", None)
        key_url = app.config.get("KEY_URL")
        self.oauth_rpc_host = app.config.get("OAUTH_RPC_HOST")

        if not host:
            logger.error("GENERATORID_IP:随机id生成器服务器地址没有配置")
            sys.exit(0)
        if not r_host:
            logger.error("REDIS_HOST:没有配置REDIS HOST")
            sys.exit(0)
        if not r_port:
            logger.error("REDIS_PORT:没有配置REDIS PORT")
            sys.exit(0)
        if not r_db:
            logger.error("REDIS_DB:没有配置REDIS DATABASE NAME")
            sys.exit(0)
        if not key_url:
            logger.error("KEY_URL: 没有配置KEY_URL")
            sys.exit(0)

        # REDIS连接
        redis.connect(r_host, r_port, r_db, r_pwd)

        # access_token 设置永久1个月token时间
        Douwa.client_access = app.config.get("ACCESS_TOKEN", list())

    def generator_id(self):
        if self.getid:
            return self.getid.GeneratorId()
        else:
            raise Exception("没有初始化")