import json
import requests

from functools import wraps
from flask import request, g, current_app
from huansi_utils.flask_douwa import redis, Douwa
from huansi_utils.app.apploader import global_verify_token_switch

TOKEN_PREFIX = "douwa:token:"
TOKEN_EXPIRES = 3600
TOKEN_EXPIRES2 = 3600 * 12 * 30
PERMISSION_PREFIX = "duowa:permission:"
KEY_PREFIX = 'douwa:key:'


def authorization(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        if not global_verify_token_switch:
            return f(*args, **kwargs)
        prefix = TOKEN_PREFIX
        key_prefix = KEY_PREFIX
        ttl = TOKEN_EXPIRES

        user = None
        token = None
        if 'Authorization' in request.headers:
            token = request.headers.get('Authorization')[7:]
            print(111, token)
        elif 'AuthKey' in request.headers:
            header_key = request.headers.get('AuthKey')[7:]
            print(222, token)
            if header_key:
                key = key_prefix + header_key
                user_cached = redis.get(key)
                if not user_cached:
                    # 发送激活key的请求
                    key_url = current_app.config.get('KEY_URL')
                    headers = {'AuthKey': 'bearer ' + header_key}
                    res = requests.get(url=key_url, headers=headers)
                    if not res.status_code == 200:
                        raise RuntimeError('KEY配置错误')

                try:
                    user_cached = redis.get(key)
                    user = json.loads(user_cached)
                except Exception as e:
                    user = None
                    raise Exception(e)
        if token:
            key = prefix + token
            print(333, key)
            user_cached = redis.get(key)
            if user_cached:
                try:
                    user = json.loads(user_cached)
                except Exception as e:
                    user = None
                    raise Exception(e)
        if not user:
            raise RuntimeError('用户没有登录')
        if token not in Douwa.client_access:
            expired = redis.ttl(key)
            if expired:
                redis.expire(key, ttl)
        else:
            redis.expire(key, TOKEN_EXPIRES2)

        g.user = user
        return f(*args, **kwargs)

    return decorated_function