# -*- coding:utf-8 -*-

from flask import current_app
from hs_rpc import rpc_request_invoke


def rpc_request_invoke_handle(func, message, app_rpc=None, app_code=None):
    '''
    调用指定app的rpc服务方的一个函数
    :param func: 服务方的函数名
    :param message: 服务方函数需要的参数，字典类型，如果服务方需要token验证message必须携带token
    :param app_rpc: 将要调用哪个app的rpc服务,为了向前兼容,app_rpc这个参数不推荐使用,改用app_code来动态识别rpc代理
    :param app_code: app_code
    :return:
    '''
    if not current_app.config.get('HSRPC_STATUS', False):
        return None

    response = rpc_request_invoke(func=func,
                                  message=message,
                                  app_rpc=app_rpc,
                                  app_code=app_code)
    return response
