# -*- coding:utf-8 -*-

import os
import re

if __name__ == '__main__':
    # 同步配置nginx配置
    app_conf_path = '/huansi/upgrade/app.conf'
    rpc_conf_path = '/huansi/upgrade/rpc.conf'
    compose_path = '/huansi/upgrade/docker-compose.yml'

    with open(compose_path, 'r') as f:
        compose_content = f.read()

    # 取出内容中ip " # ip: "192.168.0.1" "
    ip_str_list = re.findall('# ip: "(.*)"', compose_content)
    if not ip_str_list:
        raise RuntimeError('未在docker-compose.yml找到ip的配置')
    ip = str(ip_str_list[0])

    os.system('mkdir -p /data/nginx/conf/')
    if os.path.exists(app_conf_path):
        with open(app_conf_path, 'r')as f:
            app_conf_content = f.read()

        app_conf_content = app_conf_content.replace('$service_ip', ip)

        with open('/data/nginx/conf/app.conf', 'w')as f:
            f.write(app_conf_content)

    if os.path.exists(rpc_conf_path):
        with open(rpc_conf_path, 'r')as f:
            rpc_conf_content = f.read()

            rpc_conf_content = rpc_conf_content.replace('$service_ip', ip)

        with open('/data/nginx/conf/rpc.conf', 'w')as f:
            f.write(rpc_conf_content)

    with os.popen('ls | grep .tar') as f:
        cmd_txt = f.read()

    if not cmd_txt:
        raise RuntimeError('请检查文件,tar文件为空')

    app_name_list = cmd_txt.split('\n')

    for app_name in app_name_list:
        if not app_name:
            continue
        print('加载镜像:{}'.format(app_name[:-4].replace('___', "/").replace("__", ":")))
        cmd_res = os.system('docker load -i {}'.format(app_name))
        if cmd_res == 1:
            raise RuntimeError('加载失败')

    print('镜像加载完毕')
    print('开始升级程序')

    app_list_str = re.findall('# app_list: ".*"', compose_content)
    if app_list_str:
        app_list_str = app_list_str[0]
    else:
        raise RuntimeError('未设置app_list')

    app_str = app_list_str[len('# app_list: "'):-1]

    if app_str == '*':
        res = os.system('''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /huansi/upgrade/huansi.sh &&\
docker-compose -p deploy up -d --force-recreate''')
    else:
        res = os.system('''export HUANSI_REGISTRY_URL=47.110.145.204:8084 &&\
source /huansi/upgrade/huansi.sh &&\
docker-compose -p deploy up -d --force-recreate --no-deps {}'''.format(app_str))

    if res == 1: raise RuntimeError('程序升级失败')
