// import ToolClass from '@utils/toolClass'
const utilUc = {
  data() {
    return {
      page_sizes: this.$appConfig.pagination_page_sizes,
      full_loading: '',
      page: 1,
      per_page: 10,
      total: 0,
      bill_hdr: {}, // 表头明细
      bill_dtl: [], // 单表明细
      bill_hdr_id: '', // 表头id
      ui_hdr_button_edit: false, // 控制单据头的编辑按钮是否显示
      ui_readonly: true, // 永远只读
      ui_bill_hdr_disabled: true, // 单据头处于不可编辑状态：true
      ui_bill_dtl_disabled: true, // 单据明细处于不可编辑状态：true
      required_field_bill_dtl: {}, // 明细必填字段
      required_field_bill_hdr: {}, // 头表必填字段get
      bill_dtl_current_row: {}, // 明细所选择的当前行
      bill_dtl_list_dtl_dialog: [], // 单据明细的弹出框
      bill_dtl_single_detail: {} // 单据新增行
    }
  },
  computed: {
    bill_hdr_cancel_save_button: function() {
      // 单据头信息 取消保存按钮
      return this.bill_hdr.bill_status === '0' && !this.ui_bill_hdr_disabled
    },
    bill_hdr_edit_button: function() {
      // 单据头编辑按钮
      return this.bill_hdr.bill_status === '0' && this.ui_bill_hdr_disabled
    },
    bill_dtl_canael_save_button: function() {
      // 明细取消保存按钮
      return (
        this.bill_hdr.bill_status === '0' &&
        !this.ui_bill_dtl_disabled &&
        this.bill_dtl.length
      )
    },
    bill_dtl_add_button: function() {
      // 明细新增按钮
      return this.bill_hdr.id && this.bill_hdr.bill_status === '0'
    },
    bill_dtl_edit_button: function() {
      // 明细编辑按钮
      return (
        this.bill_hdr.id &&
        this.bill_hdr.bill_status === '0' &&
        this.bill_dtl.length &&
        this.ui_bill_dtl_disabled
      )
    },
    bill_hdr_delete_button: function() {
      // 单据头删除按钮
      return this.bill_hdr.bill_status === '0' && this.bill_hdr.id
    },
    bill_dtl_delete_button: function() {
      // 单据明细删除按钮
      return (
        this.bill_hdr.id &&
        this.bill_hdr.bill_status === '0' &&
        this.bill_dtl.length &&
        this.ui_bill_dtl_disabled
      )
    }
  },
  methods: {
    showLoading() {
      this.full_loading = this.$loading({
        lock: true,
        text: '加载中',
        spinner: 'el-icon-loading',
        background: 'rgba(0, 0, 0, 0.7)'
      })
    },
    closeLoading() {
      this.full_loading.close()
    },
    /**
     * 查询整个单据(含主从表)
     * @param {*} bill_hdr_id 单据头ID
     */
    query_bill(billId = this.bill_hdr_id, flage = true) {
      // 从列表进入详情的情况1
      if (billId !== '0') {
        this.query_bill_hdr(billId, flage)
        if (flage) {
          // 同步的情况单据id跟表头id一致的时候
          this.query_bill_dtl(billId)
        }
      } else {
        // 新增的情况2
        this.bill_hdr = {
          bill_status: '0'
        }
        this.bill_dtl = []
        this.ui_bill_hdr_disabled = false
      }
    },
    /**
     * 查询单据头信息
     * @param {*} bill_hdr_id 单据头ID
     */
    query_bill_hdr(billId = this.bill_hdr_id, flage) {
      if (billId) {
        const routerParms = {
          routerUrl: 'billId',
          data: {
            billId: billId
          }
        }
        this.$API
          .get(`${this.module_name}/query_one/`, routerParms)
          .then(res => {
            this.bill_hdr = res.data
            console.log(JSON.stringify(this.bill_hdr))
            this.bill_hdr_id = res.data.id // 设置表头id
            if (!flage) {
              // 异步的情况：先获取表头ID 再利用表头ID请求明细
              this.query_bill_dtl(res.data.id)
            }
            this.ui_bill_hdr_disabled = true // 设置单据头不可编辑状态
          })
      }
    },
    /**
     * 查询单据明细信息
     * @param {*} bill_hdr_id 单据头ID
     */
    query_bill_dtl(id = this.bill_hdr_id) {
      if (id) {
        const routerParms = {
          routerUrl: 'id',
          data: {
            id: id
          }
        }
        // 问号参数
        const parm2 = {
          page: this.page,
          per_page: this.per_page
        }
        // this.loading = true
        this.bill_dtl = []
        this.$API
          .get(
            `${this.bill_dtl_table}/query_list_by/bill_id/`,
            routerParms,
            parm2
          )
          .then(res => {
            this.bill_dtl = res.data.table || []
            console.log(JSON.stringify(this.bill_dtl))
            this.ui_bill_dtl = false
            this.total = res.data.paging.total
            this.page = res.data.paging.page
            this.per_page = res.data.paging.per_page
            this.ui_bill_dtl_disabled = true // 设置 单据明细为不可编辑状态
          })
      }
    },
    // 分页size cb
    handleSizeChange(pageSize) {
      this.per_page = pageSize
      if (this.page !== 1) {
        this.page = 1
      }
      this.query_bill_dtl()
    },
    // 当前页 change cb
    handleCurrentChange(currentPage) {
      this.page = currentPage
      this.query_bill_dtl()
    },
    /**
     * 校验单据头信息(保存前校验)
     */
    validate_bill_hdr(objExcept = {}) {
      let result = true
      for (const key in objExcept) {
        if (!this.bill_hdr[key]) {
          this.$message(`请您完善: ${objExcept[key]}`)
          result = false
          return
        }
      }
      return result
    },
    /**
     * 校验单据明细信息
     */
    /**
     * 校验单据明细信息
     */
    validate_bill_dtl(objExcept = {}) {
      let result = true
      for (const item of this.bill_dtl) {
        for (const key in item) {
          if (!item[key] && Reflect.has(objExcept, key)) {
            console.log(JSON.stringify(item))
            console.log(key)
            this.$message(`请您完善: ${objExcept[key]}`)
            result = false
            return
          }
        }
      }
      return result
    },
    /**
     * 保存单据头信息
     */
    save_bill_hdr(flage) {
      const result = this.validate_bill_hdr(this.required_field_bill_hdr)
      if (!result) {
        return
      }
      this.$API
        .post(`${this.module_name}/save_one/`, {}, {}, this.bill_hdr)
        .then(res => {
          this.bill_hdr = res.data
          this.bill_hdr_id = res.data.id // 设置 单据头id
          this.ui_bill_hdr_disabled = true // 设置单据头不可编辑状态
          if (flage) {
            this.replaceURL('', res.data.id)
          }
        })
    },
    /**
     * 头表编辑取消
     */
    reject_bill_hdr() {
      this.$confirm('您还未保存，确定取消吗?', '提示', {
        cancelButtonText: '取消',
        confirmButtonText: '确定',
        type: 'warning'
      }).then(() => {
        this.query_bill_hdr(this.bill_hdr.id, true)
      })
    },
    /**
     * 单据明细信息编辑取消
     */
    reject_bill_dtl() {
      this.$confirm('您还未保存，确定取消吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.query_bill_dtl(this.bill_hdr_id)
      })
    },
    /**
     * 单据明细本地新增一行
     * @param {*} bCopy 是否复制
     */
    add_new_bill_dtl(bCopy) {
      const entity = Object.assign({}, this.bill_dtl_single_detail)
      entity.bill_id = this.bill_hdr.id
      this.bill_dtl.unshift(entity)
      this.ui_bill_dtl_disabled = false
    },
    /**
     * 批量保存单据明细
     */
    save_bill_dtl() {
      const result = this.validate_bill_dtl(this.required_field_bill_dtl)
      if (!result) {
        return
      }
      this.$API
        .post(`${this.bill_dtl_table}/save_list/`, {}, {}, this.bill_dtl)
        .then(res => {
          this.query_bill_dtl(this.bill_hdr_id)
          this.ui_bill_dtl_disabled = true // 设置单据明细为不可编辑状态
        })
    },
    // 删除订单
    delete_bill() {
      const routerParm = {
        routerUrl: 'id',
        data: {
          id: this.bill_hdr_id
        }
      }
      this.$confirm('确定删除该单吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.$API
          .delete(`${this.module_name}/delete_one/`, routerParm)
          .then(res => {
            this.tabRemove()
          })
      })
    },
    /**
     * 删除单条订单
     * @param {} id 选中行的ID
     */
    deleteSingeID(id = this.bill_hdr.id) {
      // if (!id) {
      //   this.$message('您没有选中任何数据项,请选中后再操作')
      //   return
      // }
      const routerParm = {
        routerUrl: 'id',
        data: {
          id: id
        }
      }
      this.$confirm('确定删除该单吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.$API
          .delete(`${this.module_name}/delete_one/`, routerParm)
          .then(res => {})
      })
    },
    /**
     * 删除单据明细当前行
     */
    delete_curr_bill_dtl(index) {
      const id = this.bill_dtl[index].id
      this.$confirm('删除后将不能还原，确定删除吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        if (id) {
          const routerParms = {
            routerUrl: 'id',
            data: {
              id: id
            }
          }
          this.$API
            .delete(`${this.bill_dtl_table}/delete_one/`, routerParms)
            .then(res => {
              this.bill_dtl.splice(index, 1)
            })
        } else {
          this.bill_dtl.splice(index, 1)
        }
      })
    },
    /**
     * 批量删除单据明细
     * @param {*} ids 选中的单据明细id列表
     */
    delete_list_bill_dtl() {
      const list = this.multiple_select_dtl_table()
      const ids = []
      if (!list.length) {
        this.$message('请选择明细')
        return
      }
      for (const item of list) {
        if (item.id) {
          ids.push(item.id)
        }
      }
      const parm = {
        id_list: ids
      }
      this.$confirm('确定删除吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.$API
          .delete(`${this.bill_dtl_table}/delete_list/`, {}, {}, { data: parm })
          .then(res => {
            // 方案一： 再查询一次
            // this.query_bill_dtl(this.bill_hdr_id)
            // 方案二： 操作本地数据
            for (const item of list) {
              for (const index in this.bill_dtl) {
                if (item.id === this.bill_dtl[index].id) {
                  this.bill_dtl.splice(index, 1)
                }
              }
            }
          })
      })
    },
    /**
     * 计算拼接？参数的字符串
     * @param {*} args 查询参数
     */
    mergeArgsString(args = {}) {
      let param = `?`
      for (const key in args) {
        param += `&${key}=${args.key}`
      }
      return param
    },
    replaceURL(path, id) {
      // 路由跳转 path路径 query参数
      // this.$router.push(path + id)
      this.$router.replace(path + id) // 由于公用一个页面这里建议使用 replace处理
    },
    // 获取明细所有选中的list
    multiple_select_dtl_table() {
      return this.$refs.multiple_dtl_table.selection
    },
    edit_bill_hdr_butt() {
      this.ui_bill_hdr_disabled = !this.ui_bill_hdr_disabled
    },
    dtlSet() {
      this.ui_bill_dtl_disabled = !this.ui_bill_dtl_disabled
    },
    tabRemove() {
      const index = this.$store.getters.activeTabIndex
      this.$store.commit('deleteHeaderTab', { that: this, index })
    },
    // 单据-单条明细详情查询
    query_list_dtl_row_dialog() {
      const routerParms = {
        routerUrl: 'id',
        data: {
          id: this.bill_dtl_current_row.id
        }
      }
      this.bill_dtl_list_dtl_dialog = []
      this.$API
        .get(
          `${this.module_name_dtl_row_data_dialog}query_list_by/item_id/`,
          routerParms
        )
        .then(res => {
          this.visible_dtl_row_dialog = true
          this.bill_dtl_list_dtl_dialog = res.data
        })
    },
    // 双击单据明细-然后弹出明细
    double_click_row_dtl(row) {
      this.bill_dtl_current_row = row
      this.query_list_dtl_row_dialog()
    },
    // 单击 选中单据的某一条明细- 设置单行选中
    single_click_row_dtl_dialog(row) {
      this.$refs.multiple_table_inner_delete.toggleRowSelection(row)
    },
    // 批量删除 单据弹出框明细
    delete_list_dtl_dialog() {
      const list = this.$refs.multiple_table_inner_delete.selection
      const ids = []
      list.forEach(element => {
        ids.push(element.id)
      })
      const parm = { id_list: ids }
      this.$API
        .delete(
          `${this.module_name_dtl_row_data_dialog}delete_list/`,
          {},
          {},
          { data: parm }
        )
        .then(() => {
          this.query_bill_dtl(this.bill_hdr.id)
          this.query_list_dtl_row_dialog() // 获取 删除列表
        })
    }
  }
}
export default utilUc
