import ToolClass from '@utils/toolClass'
import Base from '@basicClass/base'
import billUtil from './bill_util'
const utilUc = {
  mixins: [Base, billUtil],
  data() {
    return {
      bill_hdr: {
        data: {},
        table_name: ''
      }, // 表头明细
      query_bill_parm_id: 'bill_id',
      bill_dtl: [], // 单表明细
      required_field_bill_dtl: {}, // 明细必填字段
      required_field_bill_hdr: {}, // 头表必填字段
      bill_not_check_hdr: {}, // 头部填充字段
      bill_dtl_single_detail: {}, // 单据新增行
      bill_dtl_empty: [], // id:0 默认明细
      bill_height: 100,
      formLabelWidth: '120px',
      api_bill_base_query: '',
      api_bill_base_save: '',
      api_delete_one: 'delete_one',
      api_delete_list: 'delete_list', // 批量删除
      api_dtl_row_delete_list: 'delete_list',
      dataParm: {},
      bill_hdr_empty: {},
      bill_hdr_copy: {},
      bill_hdr_data_copy: {},
      bill_dtl_copy: [],
      delete_prop: {}, // 过滤表的字典{'item_sear':'这张表废弃不显示'}
      bill_dtl_list_dtl_dialog: [], // 单据明细的弹出框
      Global_data_select: [],
      is_restful: false,
      module_name_dtl_row_dialog: '',
      is_filling: true, // 是否填充18行
      flage_prop: 'id',
      page: 1,
      per_page: 20,
      total: 0,
      retrieve: false,
      pagination: false, // 是否分页
      bill_query_parm: {},
      save_bill_query_parm: {}, // 保存时的问号参数
      save_bill_temporary_query_parm: {}, // 暂存时的问号参数
      is_out: false // 暂存时的问号参数
    }
  },
  computed: {
    /**
     * 控制单据是否可编辑
     */
    bill_editable() {
      return !(
        this.bill_hdr.data.bill_status === '0' ||
        this.bill_hdr.data.bill_status === '1' ||
        !this.bill_hdr.data.bill_status
      )
    },
    /**
     * 新增时候的状态
     */
    bill_add_status() {
      return this.bill_hdr.data.id
    },
    is_add_admin() {
      if (this.bill_hdr.data.id) {
        return true
      }
    },
    /**
     * 计算这个列表是否有有效值（id）
     */
    bill_list_empty() {
      const r =
        this.bill_hdr.data.bill_status === '0' ||
        this.bill_hdr.data.bill_status === '1'
      return !r
    },
    bill_is_send() {
      const data = this.bill_hdr.data
      return data.id !== '0' && data.id && data.bill_status === '0'
    },
    bill_back_send() {
      const data = this.bill_hdr.data
      return data.id !== '0' && data.id && data.bill_status === '1'
    },
    bill_status_0() {
      const data = this.bill_hdr.data
      return !data.id && data.bill_status === '0'
    },
    /**
     * 审核按钮
     */
    bill_status_1() {
      const data = this.bill_hdr.data
      return data.bill_status === '1'
    },
    bill_send_status() {
      const data = this.bill_hdr.data
      return !data.is_system && data.bill_status === '0'
    },
    /**
     * 取消审核按钮
     */
    bill_status_2() {
      const data = this.bill_hdr.data
      return data.bill_status === '2'
    },
    bill_status_01() {
      const data = this.bill_hdr.data
      return data.id && (data.bill_status === '0' || data.bill_status === '1')
    },
    bill_status_6() {
      const data = this.bill_hdr.data
      return data.id && data.bill_status === '6'
    }
  },
  mounted() {
    const that = this
    window.onresize = function() {
      that.$nextTick(() => {
        that.set_table_style()
      })
    }
    this.$nextTick(() => {
      this.set_table_style()
    })
  },
  activated() {
    // this.set_table_style()
  },
  methods: {
    getNowFormatDate() {
      var date = new Date()
      var seperator1 = '-'
      var year = date.getFullYear()
      var month = date.getMonth() + 1
      var strDate = date.getDate()
      if (month >= 1 && month <= 9) {
        month = '0' + month
      }
      if (strDate >= 0 && strDate <= 9) {
        strDate = '0' + strDate
      }
      var currentdate = year + seperator1 + month + seperator1 + strDate
      return currentdate
    },
    /**
     * 整单查询
     * @param {*} billId
     */
    query_bill(billId = this.bill_hdr.data.id) {
      if (billId !== '0') {
        // 详情
        const routerParms = {
          routerUrl: this.query_bill_parm_id,
          data: {
            [this.query_bill_parm_id]: billId
          }
        }
        if (this.is_restful) {
          this.api_bill_base_query = ''
        }
        if (this.pagination) {
          this.bill_query_parm.page = this.page
          this.bill_query_parm.per_page = this.per_page
        }
        this.$API
          .get(
            `${this.module_name}/${this.api_bill_base_query}/`,
            routerParms,
            this.bill_query_parm
          )
          .then(res => {
            this.bill_hdr = res.data && res.data.header
            const parm = {}
            res.data.childs.map((item, index) => {
              for (const prop in item) {
                if (item[prop] && Reflect.has(this.delete_prop, item[prop])) {
                  res.data.childs.splice(index, 1) // 删除掉 不必要的明细
                }
              }
              // 按照表名分组成字典形式
              if (
                !parm[item.table_name] &&
                !Reflect.has(this.delete_prop, item.table_name)
              ) {
                parm[item.table_name] = item
              }
            })
            this.bill_dtl = res.data.childs
            if (this.pagination) {
              this.total = this.bill_dtl[0].paging.total - 0
              this.page = this.bill_dtl[0].paging.page - 0
              this.per_page = this.bill_dtl[0].paging.per_page - 0
            }
            // 请求后调用
            this.query_bill_after()
            this.copyData()
            this.replaceURL('', res.data.header.data.id) // 替换浏览器地址栏路由
            this.item_data_reset_empty(this.bill_dtl)
          })
      } else {
        // 新增的情况2
        this.bill_hdr = ToolClass.copy_object(this.bill_hdr_empty)
        this.bill_dtl = ToolClass.copy_object(this.bill_dtl_empty)
        delete this.bill_hdr.data.id
        // 请求后调用
        this.query_bill_after()
        this.copyData()
        this.item_data_reset_empty(this.bill_dtl)
        if (!this.BillType) {
          this.$set(this.bill_hdr.data, 'bill_date', this.getNowFormatDate())
          this.$set(this.bill_hdr.data, 'sampling_rate', 10)
        }
        this.set_default()
      }
    },
    query_bill_after() {},
    set_default() {

    },
    filter_dtl_data_no_cheack() {
      const parm = {
        header: {
          table_name: this.bill_hdr.table_name,
          data: []
        },
        childs: []
      }
      // 单据头修改的数据
      parm.header.data = ToolClass.filter_change_data(
        this.bill_hdr_data_copy,
        this.bill_hdr.data,
        this.bill_not_check_hdr
      )
      // 明细修改对数据
      parm.childs = ToolClass.filterData(
        this.bill_dtl_copy,
        this.bill_dtl,
        this.required_field_bill_dtl,
        this.flage_prop
      )
      return parm
    },
    filter_dtl_data() {
      const parm = {
        header: {
          table_name: this.bill_hdr.table_name,
          data: []
        },
        childs: []
      }
      // 校验 单据头
      const r = this.validate_bill_hdr(
        this.bill_hdr.data,
        this.required_field_bill_hdr
      )
      if (!r) {
        return
      }
      // 单据头修改的数据 这里面没有校验是否必传字段
      parm.header.data = ToolClass.filter_change_data(
        this.bill_hdr_data_copy,
        this.bill_hdr.data,
        this.bill_not_check_hdr
      )
      // 明细修改对数据 里面有校验必传字段
      parm.childs = ToolClass.filterData(
        this.bill_dtl_copy,
        this.bill_dtl,
        this.required_field_bill_dtl,
        this.flage_prop
      )
      return parm
    },
    message_success(text) {
      this.$message({
        showClose: true,
        message: text,
        type: 'success'
      })
    },
    // 这个地方必须要返回一个布尔值
    bill_save_before() {
      return true
    },
    // 保存整张单据
    bill_save() {
      let iBillType = ''
      let pu_order_id = false
      if (this.is_out) {
        this.sName = this.bill_hdr.data.sName
        iBillType = this.bill_hdr.data.iBillType
        this.bill_dtl[0].data.map((item) => {
          if (!item.sFieldType || !item.sFieldName || !item.sFieldCaption) {
            pu_order_id = true
          }
        })
      }
      var arr = Object.keys(this.bill_dtl[0].data[0])
      // 修改的
      if (arr.length !== 0 && pu_order_id) {
        this.$message('带有*号的明细不可为空')
        return
      }
      this.save_bill_before()
      const parm = this.filter_dtl_data()
      if (!parm || !parm.childs) {
        return
      }
      // const routerParms = {
      //   routerUrl: 'send_bill',
      //   data: {
      //     send_bill: 'true'
      //   }
      // }
      if (this.is_restful) {
        this.api_bill_base_save = ''
      }
      if (this.$route.params.id !== '0') {
        this.save_bill_query_parm.retrieve = this.retrieve
      }
      if (this.is_out) {
        parm.header.data.sName = this.sName
        parm.header.data.iBillType = iBillType
      }
      console.log(JSON.stringify(parm))
      var r_before = this.bill_save_before()
      if (!r_before) return
      this.$API
        .post(
          `${this.module_name}/${this.api_bill_base_save}/`, {},
          this.save_bill_query_parm,
          parm
        )
        .then(res => {
          // 处理保存后的逻辑
          if (!this.retrieve && this.$route.params.id !== '0') {
            this.query_bill()
          } else {
            this.deal_data(res.data)
          }

          this.message_success('保存成功！')
        })
    },
    // 保存前操作
    save_bill_before() {},
    /**
     * 刷新
     */
    bill_refresh() {
      if (this.bill_hdr.data.id) {
        const result = this.is_leave_page()
        if (!result) {
          this.query_bill(this.$route.params.id) // 这里有问题
        } else {
          result
            .then(() => {
              this.query_bill(this.bill_hdr.data.id)
            })
            .catch(() => {})
        }
      }
      this.Global_data_select = []
    },
    /**
     * 上一单下一单 flage 1 上 flage2 下
     * @param {*} flage
     */
    get_next_by_bill_no(flage) {
      const routerParms = {
        routerUrl: 'bill_no',
        data: {
          bill_no: this.bill_hdr.data.bill_no
        }
      }
      const aip = flage === 1 ? 'last_order' : 'next_order'
      this.base_bill_query(routerParms, {}, aip, this.module_name).then(res => {
        if (res.data === null) {
          const message =
            flage === 1 ? '这已经是第一条了' : '这已经是最后一条了'
          this.$message(message)
          return
        }
        this.replaceURL('', res.data.header.data.id) // 替换浏览器地址栏路由
        this.bill_hdr = res.data.header
        this.bill_dtl = res.data.childs
        this.copyData()
        this.item_data_reset_empty(this.bill_dtl)
      })
    },
    bill_next_up_down(flage) {
      const result = this.is_leave_page()
      if (!result) {
        this.get_next_by_bill_no(flage)
      } else {
        result
          .then(() => {
            this.get_next_by_bill_no(flage)
          })
          .catch(() => {})
      }
    },
    /**
     * 初始化数据
     * @param {*} list
     */
    item_data_reset_empty(list) {
      if (!this.is_filling) return
      list.map(item => {
        // if (item.data.length < 18) {
        //   const n = 18 - item.data.length
        //   for (let i = 0; i < n; i++) {
        //     item.data.push({})
        //   }
        // }
        if (!item.data.length) {
          item.data.push({})
        }
      })
    },
    copyData() {
      this.bill_hdr_copy = ToolClass.copy_object(this.bill_hdr)
      this.bill_hdr_data_copy = ToolClass.copy_object(this.bill_hdr.data)
      this.bill_dtl_copy = ToolClass.copy_object(this.bill_dtl)
    },
    /**
     * 校验单据头信息(保存前校验)
     */
    validate_bill_hdr(data, objExcept = {}) {
      let result = true
      for (const key in objExcept) {
        if (!data[key]) {
          this.$message(`请您完善: ${objExcept[key]}`)
          result = false
          return
        }
      }
      return result
    },
    /**
     * 校验单据明细信息
     */
    validate_bill_dtl(data, objExcept = {}) {
      let result = true
      for (const item of data) {
        if (item.iUpdateStatus !== 4) {
          for (const key in objExcept) {
            if (!item[key]) {
              this.$message(`请您完善: ${objExcept[key]}`)
              result = false
              return
            }
          }
        }
      }
      return result
    },
    /**
     * 单据明细本地新增一行
     * @param {*} bCopy 是否复制
     */
    add_new_bill_dtl(index, data) {
      data.unshift({})
    },
    // 删除后不用新增空白的单子
    delete_bill() {
      if (!this.bill_hdr.data.id) {
        this.$message('不能进行删除')
        return
      }
      this.$confirm('确定删除该单吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        if (this.is_restful) {
          this.api_delete_one = ''
        }
        this.before_delete_hint(
          [this.bill_hdr.data.id],
          this.bill_type,
          this.delete_bill_only
        )
      })
    },
    delete_bill_only(id) {
      const parm = {
        id_list: id
      }
      this.$API
        .delete(`${this.module_name}/${this.api_delete_one}/`, {}, {}, parm)
        .then(res => {
          this.$message.success('删除成功')
          this.tabRemove()
        })
    },
    delete_bill_add_empty(val) {
      const id = this.bill_hdr.data.id
      if (!id) {
        this.$message('不能进行删除')
        return
      }
      this.$confirm('确定删除该单吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.before_delete_hint([id], this.bill_type, this.go_delete_detail)
      })
    },
    /**
     * 删除单据明细当前行
     */
    delete_curr_bill_dtl(index, data) {
      if (data.length <= 18) {
        data[index] = {}
        this.$set(data, index, data[index])
      } else {
        data.splice(index, 1)
      }
    },
    replaceURL(path, id) {
      // 路由跳转 path路径 query参数
      const oldId = this.$route.params.id
      if (oldId === id) {
        return
      }
      this.$router.replace(path + id) // 由于公用一个页面这里建议使用 replace处理
    },
    set_table_style() {
      const containerHeight =
        document.getElementById('container') &&
        document.getElementById('container').clientHeight
      const headerHeight =
        document.getElementById('header') &&
        document.getElementById('header').clientHeight
      this.bill_height = containerHeight - headerHeight - 60
    },
    // 获取明细所有选中的list
    multiple_select_dtl_table() {
      return this.$refs.multiple_dtl_table.selection
    },
    tabRemove() {
      const index = this.$store.getters.activeTabIndex
      this.$store.commit('deleteHeaderTab', {
        that: this,
        index
      })
    },
    getSummaries(param) {
      const {
        columns,
        data
      } = param
      const sums = []
      let _sums = 0
      for (const item of data) {
        for (const prop in item) {
          if (item[prop]) {
            _sums++
            break
          }
        }
      }
      columns.forEach((column, index) => {
        if (index === 0) {
          sums[index] = '合计'
          return
        }
        if (index === 1) {
          sums[index] = _sums
          return
        }
        const {
          property
        } = column
        this.summaryAttr.forEach(sum => {
          const {
            type,
            attr
          } = sum
          if (property === attr) {
            const values = data.map(item => {
              const val = Number(item[column.property])
              return isNaN(val) ? 0 : val
            })
            if (values.length) {
              const count = values.reduce((prev, curr) => {
                return prev + curr
              }, 0)
              switch (type) {
                case 'sum':
                  sums[index] = count
                  break
                case 'ava':
                  sums[index] = _sums === 0 ? '-' : (count / _sums).toFixed(2)
                  break
              }
            } else {
              sums[index] = '-'
            }
          }
        })
      })
      return sums
    },
    /**
     * 合计字段
     * @param {d\} param
     */
    getSummaries2(param) {
      const {
        columns,
        data
      } = param
      const sums = []
      columns.forEach((column, index) => {
        if (index === 0) {
          sums[index] = '合计'
          return
        }
        this.summaryAttr.forEach(attr => {
          if (column.property === attr) {
            const values = data.map(item => Number(item[column.property]))
            if (!values.every(value => isNaN(value))) {
              sums[index] = values.reduce((prev, curr) => {
                const value = Number(curr)
                if (!isNaN(value)) {
                  return prev + curr
                } else {
                  return prev
                }
              }, 0)
              // sums[index] += ' '
            } else {
              sums[index] = '-'
            }
          }
        })
      })
      return sums
    },
    delete_one(id) {
      this.base_delete_one(id).then(() => {
        this.tabRemove()
      })
    },
    delete_list(ids) {
      const parm = {
        id_list: ids
      }
      this.base_delete_list(parm).then(() => {
        // 删除后的处理逻辑
      })
    },
    is_leave_page() {
      // const parm = this.filter_dtl_data_no_cheack()
      // if (!parm) {
      //   return
      // }
      // const dataHdr = parm.header.data
      // console.log(dataHdr)
      // const p1 = dataHdr.id && Object.keys(dataHdr).length === 1
      // const p2 = !dataHdr.id && !Object.keys(dataHdr).length
      // if ((p1 || p2) && !parm.childs.length) {
      //   return
      // } else {
      //   return this.$confirm('数据尚未保存,继续将会丢失', '提示', {
      //     confirmButtonText: '确定',
      //     cancelButtonText: '取消',
      //     type: 'warning'
      //   })
      // }
    },
    add_bill() {
      const result = this.is_leave_page()
      if (!result) {
        this.deal_data()
      } else {
        result.then(() => {
          this.deal_data()
        })
      }
    },
    /**
     * 暂存
     */
    bill_save_temporary() {
      const parm = this.filter_dtl_data_no_cheack()
      const dataHdr = parm.header.data
      const p1 = dataHdr.id && Object.keys(dataHdr).length === 1
      const p2 = !dataHdr.id && !Object.keys(dataHdr).length
      if ((p1 || p2) && !parm.childs.length) {
        this.$message('数据未做改变，请重新检查')
        return
      }
      const routerParms = {
        routerUrl: 'send_bill',
        data: {
          send_bill: 'false'
        }
      }
      if (this.is_restful) {
        this.api_bill_base_save = ''
      }
      if (this.$route.params.id !== '0') {
        this.save_bill_temporary_query_parm.retrieve = this.retrieve
      }
      this.$API
        .post(
          `${this.module_name}/${this.api_bill_base_save}/`,
          routerParms,
          this.save_bill_temporary_query_parm,
          parm
        )
        .then(res => {
          this.message_success('暂存成功！')
          // 处理保存后的逻辑
          if (!this.retrieve && this.$route.params.id !== '0') {
            this.query_bill()
          } else {
            this.deal_data(res.data)
          }
        })
    },
    deal_data(data) {
      if (data) {
        this.replaceURL('', data.header.data.id) // 替换浏览器地址栏路由
        this.bill_hdr = data.header
        this.bill_dtl = data.childs
        this.copyData()
        this.item_data_reset_empty(this.bill_dtl)
      } else {
        this.replaceURL('', 0) // 替换浏览器地址栏路由
        this.bill_hdr = ToolClass.copy_object(this.bill_hdr_empty)
        this.bill_dtl = ToolClass.copy_object(this.bill_dtl_empty)
        this.copyData()
        this.item_data_reset_empty(this.bill_dtl)
        this.$set(this.bill_hdr.data, 'bill_date', this.getNowFormatDate())
        this.$set(this.bill_hdr.data, 'sampling_rate', 10)
        this.set_default()
      }
    },
    /**
     * 单据审核
     */
    bill_audit() {
      this.audit_bills([this.bill_hdr.data.id]).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    /**
     * 单据发送sendsend
     */
    bill_send() {
      this.sendedi_bills([this.bill_hdr.data.id], this.send).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    /**
     * 单据发送撤回
     */
    bill_un_send() {
      this.sendedi_un_bills([this.bill_hdr.data.id], this.send).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    /**
     * 反审
     */
    bill_un_audit() {
      this.un_audit_bills([this.bill_hdr.data.id]).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    /**
     * 完结
     */
    bill_close_bills() {
      this.close_bills([this.bill_hdr.data.id]).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    bill_un_close_bills() {
      this.un_close_bills([this.bill_hdr.data.id]).then(() => {
        this.query_bill(this.bill_hdr.data.id)
      })
    },
    /**
     *
     * 复制整单
     */
    bill_copy_data_handle() {
      const hdr = ToolClass.copy_object(this.bill_hdr_copy)
      delete hdr.data.id
      delete hdr.data.bill_status
      delete hdr.data.bill_no
      delete hdr.data.create_time
      const billDtl = ToolClass.copy_object(this.bill_dtl_copy)
      for (const item of billDtl) {
        for (const jtem of item.data) {
          delete jtem.id
          delete jtem.bill_id
        }
      }
      this.bill_hdr = hdr
      this.bill_hdr_data = hdr.data
      this.bill_dtl = billDtl
      this.bill_hdr_copy = ToolClass.copy_object(this.bill_hdr_empty)
      this.bill_hdr_data_copy = ToolClass.copy_object(this.bill_hdr_empty.data)
      this.bill_dtl_copy = ToolClass.copy_object(this.bill_dtl_empty)
      this.item_data_reset_empty(this.bill_dtl)
      this.replaceURL('', '0') // 替换浏览器地址栏路由
    },
    bill_copy() {
      const result = this.is_leave_page()
      if (!result) {
        this.bill_copy_data_handle()
      } else {
        result
          .then(() => {
            this.bill_copy_data_handle()
          })
          .catch(() => {})
      }
    },
    // 单据-单条明细详情查询
    query_list_dtl_row_dialog() {
      const routerParms = {
        routerUrl: 'bill_id/check_code',
        data: {
          bill_id: this.bill_hdr.data.id,
          check_code: this.bill_dtl_current_row.check_code
        }
      }
      this.bill_dtl_list_dtl_dialog = []
      this.$API
        .get(
          `${this.module_name}/${this.module_name_dtl_row_dialog}/`,
          routerParms
        )
        .then(res => {
          this.visible_dtl_row_dialog = true
          this.bill_dtl_list_dtl_dialog = res.data
        })
    },
    // 双击单据明细-然后弹出明细
    double_click_row_dtl(row) {
      if (!row[this.flage_prop]) {
        this.$message('暂无数据')
        return
      }
      this.bill_dtl_current_row = row
      this.query_list_dtl_row_dialog()
    },
    // 单击 选中单据的某一条明细- 设置单行选中
    single_click_row_dtl_dialog(row) {
      this.$refs.multiple_table_inner_delete.toggleRowSelection(row)
    },
    // 批量删除 单据弹出框明细
    delete_list_dtl_dialog() {
      const list = this.$refs.multiple_table_inner_delete.selection
      if (!list.length) {
        this.$message('暂无数据')
        return
      }
      const ids = []
      for (const element of list) {
        ids.push(element.id)
      }
      const parm = {
        id_list: ids
      }
      if (this.is_restful) {
        this.api_dtl_row_delete_list = ''
      }
      this.$API
        .delete(
          `${this.module_name}/${this.module_name_dtl_row_dialog}/${
            this.api_dtl_row_delete_list
          }`, {}, {},
          parm
        )
        .then(() => {
          this.query_bill()
          this.visible_dtl_row_dialog = false
        })
    },
    async go_delete_detail(bill_ids = []) {
      // 把单据状态为已送审的取消送审再删除
      if (this.bill_status_1) {
        await this.un_send_bills(bill_ids)
      }
      const parm_delete = {
        id_list: bill_ids
      }
      if (this.is_restful) {
        this.api_delete_list = ''
      }
      this.$API
        .delete(
          `${this.module_name}/${this.api_delete_list}/`, {}, {},
          parm_delete
        )
        .then(res => {
          this.$message('删除成功！')
          this.bill_hdr = ToolClass.copy_object(this.bill_hdr_empty)
          this.bill_dtl = ToolClass.copy_object(this.bill_dtl_empty)
          delete this.bill_hdr.data.id
          this.replaceURL('', '0') // 替换浏览器地址栏路由
          this.set_delete_default()
          this.copyData()
          this.item_data_reset_empty(this.bill_dtl)
        })
    },
    set_delete_default() {

    },
    down_Template(file_name) {
      if (!file_name) {
        this.$message.error('请设置文件名')
        return
      }
      this.$API.down_Template(file_name)
    },
    cell_click(row, column) {
      if (column.type === 'selection') {
        this.$refs.multiple_dtl_table.toggleRowSelection(row)
      } else {
        this.$refs.multiple_dtl_table.clearSelection() // 先清除掉其他的
        this.$refs.multiple_dtl_table.toggleRowSelection(row)
      }
    },
    // 分页size cb
    handleSizeChange(pageSize) {
      this.per_page = pageSize - 0
      if (this.page !== 1) {
        this.page = 1
      }
      const result = this.is_leave_page()
      if (!result) {
        this.query_bill()
      } else {
        result
          .then(() => {
            this.query_bill()
          })
          .catch(() => {
            //
          })
      }
    },
    // 详情页单个删除
    bill_delete_list_del() {
      this.$API.delete(`mesAPI/pu_order/${this.bill_hdr.data.id}`).then(res => {
        this.$message('删除成功！')
        this.$router.push(this.path)
      })
    },
    back_list() {
      this.$router.push(this.path)
    },
    // 当前页 change cb
    handleCurrentChange(currentPage) {
      this.page = currentPage - 0
      const result = this.is_leave_page()
      if (!result) {
        this.query_bill()
      } else {
        result
          .then(() => {
            this.query_bill()
          })
          .catch(() => {
            //
          })
      }
    }
  }
}
export default utilUc
