import router from './index.js'
import 'nprogress/nprogress.css' // Progress 进度条样式
import store from '../store/storeAll'
import axios from 'axios'
function filterTo(to) {
  const path_list = ['/login', '/logout', '/', '/register']
  if (path_list.includes(to.path)) return
  const row = {
    meta: to.meta,
    routerName: to.name,
    params: to.params,
    path: to.path,
    query: to.query
  }
  if (to.meta.tabAttr === 'constant') {
    const common_data = sessionStorage.subs_menu ? JSON.parse(sessionStorage.subs_menu) : []
    const smt = common_data.find(item => {
      return '/' + item.index === to.path
    })
    if (smt) {
      row.name = smt.name
    } else {
      row.name = to.name
    }
    pushHeaderTab(row)
  } else if (to.meta.tabAttr === 'variable') {
    if (to.params.type && to.params.id) {
      to.meta.tabName.forEach(item => {
        if (to.params.type === item.type) {
          row.name =
            to.params.id === '0' || !to.params.id ? item.addName : item.editName
          pushHeaderTab(row)
        }
      })
    } else if (to.params.id && !to.params.type) {
      row.name =
        to.params.id === '0'
          ? to.meta.tabName['0'].addName
          : to.meta.tabName['0'].editName
      pushHeaderTab(row)
    }
  } else {
    row.name = '数据有误'
    pushHeaderTab(row)
  }
}

function pushHeaderTab(tab) {
  store.commit('pushHeaderTab', tab)
}
export function routerBeforeEach() {
  router.beforeEach((to, from, next) => {
    const { matched } = to
    if (matched.length > 1) {
      localStorage['page_path'] = matched[1].path
    } else if (matched.length === 1) {
      localStorage['page_path'] = matched[0].path
    } else {
      localStorage['page_path'] = '/error/404'
    }
    axios.defaults.headers.common['page_path'] = localStorage['page_path']
    if (sessionStorage.user_info) {
      axios.defaults.headers.common['user_info'] = sessionStorage.user_info
    }
    // 清除 debug_sql
    store.commit('clean_bug_sql_info')
    // 更新字段时间
    if (sessionStorage.exist_str) {
      const post_data = JSON.parse(sessionStorage.exist_str)
      post_data.update_read_time = true
      sessionStorage.exist_str = ''
    }
    // 清楚 trans_str
    if (sessionStorage.trans_str) {
      if (to.path === '/login') {
        sessionStorage.trans_str = ''
      } else {
        // todo: 注册字段
        const post_data = {
          path: '',
          lang_data: []
        }
        const path = sessionStorage.trans_str.split(':')[0] ? sessionStorage.trans_str.split(':')[0] : localStorage.page_path
        post_data.path = path
        const key_arr = sessionStorage.trans_str.split(':')[1].split(',')
        key_arr.forEach(key => {
          const item = {
            sKey: key,
            sValue: ''
          }
          post_data.lang_data.push(item)
        })
        sessionStorage.trans_str = ''
      }
    }
    axios.defaults.headers.common['debug_sql'] = false
    sessionStorage['debug_sql'] = false
    const token = window.sessionStorage.getItem('mes_token')
    if (token) axios.defaults.headers.common['Authorization'] = token
    filterTo(to)
    document.title = to.name ? to.name : 'HSCC'
    if (to.path !== '/login' && (!token || token === null)) {
      next({
        path: '/login',
        query: { redirect: to.fullPath }
      })
    } else if (to.path === '/login' && (token || token !== null)) {
      if (from.path) {
        next({
          path: from.path
        })
      } else {
        next({
          path: '/dashboard'
        })
      }
    } else if (to.path === '/dashboard' || to.path === '/error/404') {
      next()
    } else {
      if (to.matched.length === 0) {
        next({
          path: '/error/404'
        })
      } else {
        next()
      }
      if (to.path === '/') {
        next({
          path: '/dashboard'
        })
        return
      }
    }
  })
}
