// ===================SYS===================
// import sysMain from '@sys/main'
const Main = r =>
  require.ensure([], () => r(require('@/components/layout/main')))
const systemSet = r => require.ensure([], () => r(require('@sys/system_set')))
const Tenant = r => require.ensure([], () => r(require('@sys/tenant')))
const Staff = r => require.ensure([], () => r(require('@sys/staff/staff')))
const StaffAdd = r =>
  require.ensure([], () => r(require('@sys/staff/staff_add')))
const StaffEdit = r =>
  require.ensure([], () => r(require('@sys/staff/staff_edit')))
const RolePermission = r =>
  require.ensure([], () => r(require('@sys/role_permission')))
const CompanyInfo = r =>
  require.ensure([], () => r(require('@sys/company/company')))
const CompanyEdit = r =>
  require.ensure([], () => r(require('@sys/company/company_edit')))
const Department = r => require.ensure([], () => r(require('@sys/department')))
// ===================MD===================
const BasicDataInfo = r =>
  require.ensure([], () => r(require('@md/basic_data/basic_data_info')))
const Customer = r =>
  require.ensure([], () => r(require('@md/customer/customer_info')))
const CustomerEdit = r =>
  require.ensure([], () => r(require('@md/customer/customer_edit')))
const sysRouter = [
  {
    name: '系统设置',
    path: 'systemSet',
    component: systemSet,
    meta: {
      tabAttr: 'constant',
      value: 'systemSet'
    }
  },
  {
    name: '部门信息',
    path: 'department',
    component: Department,
    meta: {
      tabAttr: 'constant',
      value: 'department'
    }
  },
  {
    name: '角色权限管理',
    path: 'rolePermission',
    component: RolePermission,
    meta: {
      tabAttr: 'constant',
      value: 'rolePermission'
    }
  },
  {
    name: '员工',
    path: 'staff',
    component: Staff,
    meta: {
      tabAttr: 'constant',
      value: '/staff'
    }
  },
  {
    name: '租户',
    path: 'tenant',
    component: Tenant,
    meta: {
      tabAttr: 'constant',
      value: '/tenant'
    }
  },
  {
    name: '员工添加',
    path: 'staff_add',
    component: StaffAdd,
    meta: {
      tabAttr: 'constant',
      value: '/staff_add'
    }
  },
  {
    name: '员工编辑',
    path: 'staff_edit/:id',
    component: StaffEdit,
    meta: {
      tabAttr: 'constant',
      value: '/staff_edit/:id'
    }
  },
  {
    name: '公司信息',
    path: 'companyInfo',
    component: CompanyInfo,
    meta: {
      tabAttr: 'constant',
      value: 'companyInfo'
    }
  },
  {
    name: '客户信息',
    path: 'company_edit/:id',
    component: CompanyEdit,
    meta: {
      tabAttr: 'variable',
      value: 'company_edit',
      tabName: [
        {
          addName: '公司信息新增',
          editName: '公司信息详情'
        }
      ]
    }
  },
  {
    path: '/md',
    name: 'md',
    component: Main,
    children: [
      {
        name: '基础信息',
        path: 'basicDataInfo',
        component: BasicDataInfo,
        meta: {
          tabAttr: 'constant',
          value: 'basicDataInfo'
        }
      },
      {
        name: '客户信息',
        path: 'company_edit/:id',
        component: CompanyEdit,
        meta: {
          tabAttr: 'variable',
          value: 'company_edit',
          tabName: [
            {
              addName: '公司信息新增',
              editName: '公司信息详情'
            }
          ]
        }
      },
      {
        name: '客户',
        path: 'customer',
        component: Customer,
        meta: {
          tabAttr: 'constant',
          value: 'customer'
        }
      },
      {
        name: '客户信息',
        path: 'customer_edit/:id',
        component: CustomerEdit,
        meta: {
          tabAttr: 'variable',
          value: 'customer_edit',
          tabName: [
            {
              addName: '客户新增',
              editName: '客户详情'
            }
          ]
        }
      }
    ]
  }
]
export default sysRouter
