import { Message } from 'element-ui'
const ToolClass = {
  // 按照字段名来分组
  group_by_name(list, fname) {
    const fobj = list.reduce((prov, next) => {
      if (!prov[next[fname]]) {
        const parm = {}
        parm[fname] = next[fname]
        parm.data = [next]
        prov[next[fname]] = parm
      } else {
        prov[next[fname]].data.push(next)
      }
      return prov
    }, {})
    const result = []
    for (const prop in fobj) {
      result.push(fobj[prop])
    }
    return result
  },
  // 筛选出改动的数据
  filter_change_data(oldData = {}, newData = {}, billNotCheck = {}) {
    const oldDataold = this.copy_object(oldData)
    const newDataO = this.copy_object(newData)
    const parm = {}
    for (const prop in newDataO) {
      const op = oldDataold[prop]
      const np = newDataO[prop]
      const false_list = [undefined, null, '']
      if (Array.isArray(op) && Array.isArray(np)) {
        const str_op = op.sort().toString()
        const str_np = np.sort().toString()
        if (str_op !== str_np) {
          parm[prop] = newDataO[prop]
        }
        continue
      }
      if (op !== np || Reflect.has(billNotCheck, prop)) {
        const jop = false_list.includes(op)
        const pnp = false_list.includes(np)
        if (jop && pnp) {
          delete newDataO[prop]
        } else {
          parm[prop] = newDataO[prop]
        }
      }
    }
    return parm
  },
  // 这是数组的形式
  filter_change_data_array(copyData = [], newData = []) {
    const copyDataO = this.copy_object(copyData)
    const newDataO = this.copy_object(newData)
    // iUpdateStatus: 4 删除，1新增 2 修改
    const deleteList = [] // 被删的明细
    const changeList = [] // 改变的数据
    const oldIds = []
    const copyList = [] // 跟haveIdList中id能够对应的copy数据
    let addList = [] // 新增的明细
    let haveIdList = [] // 最后留下了的拥有id明细
    addList = newDataO.filter(item => {
      if (!item.id) {
        item.iUpdateStatus = 1
      }
      return !item.id
    })
    haveIdList = newDataO.filter(item => {
      if (item.id) {
        oldIds.push(item.id)
      }
      return item.id
    })
    copyDataO.map(item => {
      const parm = {
        iUpdateStatus: 4
      }
      if (oldIds.indexOf(item.id) === -1) {
        // 如果说id不存在 说明就被删除了
        parm.id = item.id
        deleteList.push(parm)
      } else {
        copyList.push(item)
      }
    })
    for (const item of copyList) {
      for (const jtem of haveIdList) {
        if (jtem.id === item.id) {
          const parm = {
            iUpdateStatus: 2
          }
          for (const prop in jtem) {
            if (jtem[prop] !== item[prop]) {
              parm[prop] = jtem[prop]
              parm['id'] = jtem['id']
            }
          }
          if (Object.keys(parm).length > 1) {
            changeList.push(parm)
          }
        }
      }
    }
    const data = [].concat(changeList, addList, deleteList)
    return data
  },
  // 深度拷贝对象// 简单数据类型没问题 如果复杂了就有问题
  copy_object(obj) {
    return JSON.parse(JSON.stringify(obj))
  },
  // 深度拷贝
  deep_clone(target) {
    if (!target && typeof target !== 'object') {
      throw new Error('error arguments', 'shallowClone')
    }
    const targetObj = target.constructor === Array ? [] : {}
    Object.keys(target).forEach(prop => {
      if (target[prop] && typeof target[prop] === 'object') {
        targetObj[prop] = this.deep_clone(target[prop])
      } else {
        targetObj[prop] = target[prop]
      }
    })
    return targetObj
  },
  // 一表多从表的筛选数据
  filterData(
    oldData = [],
    newData = [],
    requiredField = {},
    flage_prop = 'id'
  ) {
    const oldDataold = this.copy_object(oldData)
    const newDataO = this.copy_object(newData)
    const changeDataList = []
    const addDataList = []
    const oldIds = []
    const newIds = []
    const deleteList = []
    for (const jtem of oldDataold) {
      for (const ltem of jtem.data) {
        if (ltem[flage_prop]) {
          ltem.table_name = jtem.table_name
          oldIds.push(ltem)
        }
      }
    }
    if (oldIds.length === 0) {
      for (const item of newDataO) {
        const list_data = []
        item.data.forEach((wtem, index) => {
          if (Object.keys(wtem).length) {
            wtem.iUpdateStatus = 1
            list_data.push(wtem)
          }
          item.data = list_data
        })
      }
      newDataO.forEach((item, index) => {
        if (!item.data.length) {
          newDataO.splice(index, 1)
        }
      })
      return newDataO
    } else {
      for (const item of newDataO) {
        for (const wtem of item.data) {
          // 找出新增的明细
          if (wtem[flage_prop]) {
            newIds.push(wtem[flage_prop])
          } else {
            const parm = this.copy_object(wtem)
            for (const i in parm) {
              if (!parm[i] && parm[i] !== 0) {
                delete parm[i]
              }
            }
            if (Object.keys(parm).length) {
              parm.iUpdateStatus = 1
              parm.table_name = item.table_name
              for (const prop in requiredField) {
                if (!parm[prop]) {
                  Message('请完善信息:' + requiredField[prop])
                  return
                }
              }
              addDataList.push(parm)
            }
          }
        }
        for (const jtem of oldDataold) {
          // 找出修改的明细
          for (const ltem of jtem.data) {
            for (const dtem of item.data) {
              const parm = {}
              for (const prop in dtem) {
                if (Reflect.has(requiredField, prop) && !dtem[prop]) {
                  Message('请完善信息:' + requiredField[prop])
                  return
                }
                if (
                  dtem[prop] !== ltem[prop] &&
                  dtem[flage_prop] &&
                  dtem[flage_prop] === ltem[flage_prop]
                ) {
                  parm[prop] = dtem[prop]
                  parm[flage_prop] = dtem[flage_prop]
                  parm.iUpdateStatus = 2
                  parm.table_name = item.table_name
                }
              }
              if (Object.keys(parm).length) {
                changeDataList.push(parm)
              }
            }
          }
        }
      }
      for (const item of oldIds) {
        // 查找删除掉的明细
        console.log(item, 22)
        if (newIds.indexOf(item[flage_prop]) === -1) {
          const parm = {}
          parm[flage_prop] = item[flage_prop]
          parm.iUpdateStatus = 4
          parm.table_name = item.table_name
          deleteList.push(parm)
        }
      }
      // 组合所有数据
      var allList = [].concat(changeDataList, addDataList, deleteList)
      return this.group_by_name(allList, 'table_name') // 按照表名来分组
    }
  }
}
export default ToolClass
