var express = require('express')
var proxy = require('http-proxy-middleware')
var compression = require('compression')
var app = express()
app.use(compression())
let mesApi = 'http://118.126.103.194:8080' // 正式环境的后端服务器
let authApi = 'http://47.97.182.182:32621'
// let authApi = 'http://localhost:32621'

if (typeof process.env.API !== 'undefined' && process.env.API !== '') {
  mesApi = process.env.API
} else {
  console.error('Env API is lost')
}
if (typeof (process.env.OAUTHAPI) !== 'undefined' && process.env.OAUTHAPI !== '') {
  authApi = process.env.OAUTHAPI
} else {
  console.error('Env AUTHAPI is lost')
}

// static
app.use('/', express.static('dist'))
app.use(
  '/mesAPI',
  proxy({
    target: mesApi,
    pathRewrite: {
      '^/mesAPI': ''
    },
    logLevel: 'debug'
  })
)
app.use(
  '/mockAPI',
  proxy({
    target: mesApi,
    pathRewrite: {
      '^/mockAPI': ''
    },
    logLevel: 'debug'
  })
)
app.use(
  '/erpAPI',
  proxy({
    target: mesApi,
    pathRewrite: {
      '^/erpAPI': ''
    },
    logLevel: 'debug'
  })
)
app.use(
  '/authAPI',
  proxy({
    target: authApi,
    pathRewrite: {
      '^/authAPI': ''
    },
    logLevel: 'debug'
  })
)
var port = process.env.PORT || 8999 // 重要的一点
app.listen(port)
console.log('Running on http://localhost:' + port)
